package UK.co.demon.asmodeus.jigsaw;

import java.io.* ;
import java.util.*;
import java.net.*;

import UK.co.demon.asmodeus.util.*;

import w3c.tools.store.*;
import w3c.www.http.*;
import w3c.jigsaw.http.* ;
import w3c.jigsaw.resources.*;
import w3c.jigsaw.forms.*;

//
// $Log: GlossaryFilter.java,v $
// Revision 2.1  1997/06/13 13:14:24  joel
// Now uses style elements to differentiate glossary links from normal
// ones.
//
// Revision 2.0  1997/06/02 21:14:18  joel
// This is the first version of the updated resource which uses a parallel
// search for all the glossary terms at the same time.
//
// Revision 1.1  1997/06/02 21:12:50  joel
// Initial revision
//
//

/* Email : joel@asmodeus.demon.co.uk */
 
/**
 * This filter processes a normal entity body through a glossary marking
 * filter. Now much faster using a parallel search
 */
public class GlossaryFilter extends ResourceFilter 
  {
  public static final String RCSID="$Id: GlossaryFilter.java,v 2.1 1997/06/13 13:14:24 joel Exp $";

  /** 
   * Handle our filtering. Either pass straight through or handle the
   * conversion of glossary entries to hot-links
   * @param request Request descriptor from Jigsaw
   * @param reply Default reply descriptor from Jigsaw
   * @return reply possibly containing highlighted glossary entries
   * @exception w3c.jigsaw.http.HTTPException thrown if there is a problem with the request
   */
  public Reply outgoingFilter (Request request, Reply reply) throws HTTPException
    {
    // Some sanity checks:
    if (reply.getStatus() != HTTP.OK) return reply;

    // No glossary request.
    if(!request.hasState("query")) return(reply);
 
    // Anslem - is there a faster way of getting this information ?
    //          I don't like having to parse all the query info again !
    String query = request.getQueryString() ;
    InputStream qin = new StringBufferInputStream(query) ;
    URLDecoder d = new URLDecoder (qin, true);
    try 
      {
      d.parse () ;
      } 
    catch (URLDecoderException e) 
      {
      Reply error = request.makeReply(HTTP.BAD_REQUEST) ;
      error.setContent("Invalid request:unable to decode form data.");
      throw new HTTPException (error) ;
      } 
    catch (IOException e) 
      {
      Reply error = request.makeReply(HTTP.BAD_REQUEST) ;
      error.setContent("Invalid request: unable to read form data.");
      throw new HTTPException (error) ;
      }

    /* No glossary file */
    if(d.getValue("glossary")==null) return(reply);
        
    HTTPResource root=request.getClient().getServer().root;
    LookupState ls=new LookupState(d.getValue("glossary"));
    LookupResult lr=new LookupResult(root);
    root.lookup(ls,lr);
    
    HTTPResource glossary=lr.getTarget();

    if(glossary==null || !(glossary instanceof GlossaryResource)) 
      {
      Reply r = request.makeReply(HTTP.INTERNAL_SERVER_ERROR);
      r.setContent("<P>Glossary "+d.getValue("glossary")+" does not exist or is not a GlossaryResource !</P>");
      r.setExpires(-1);
      throw new HTTPException(r);
      }

    InputStream in = reply.openStream() ;
    if ( in == null ) return null;
    markGlossary((GlossaryResource)glossary,in,request,reply);
    return reply ;
    }

  /**
   * this function marks all of the entries from the glossary which appear in 
   * the input HTML stream with hyperlinks to the appropriate glossary 
   * definition. Each annotation has class "glossary" and a HEAD element
   * to define class "glossary" as colour red is added to the stream.
   * @see GlossaryResource
   * @param glossary A reference to the glossary resource which contains the
   *                 requested terms.
   * @param source the input HTML stream to parse and annotate
   * @param request the Jigsaw request 
   * @param reply the Jigsaw reply
   */
  void markGlossary(GlossaryResource glossary,InputStream source,Request request,Reply reply) throws HTTPException
    {
    MultiSearchReader root;
    int start;
    BufferedReader cookedSource=new BufferedReader(new InputStreamReader(source));
    ByteArrayOutputStream buffer=new ByteArrayOutputStream();
    Writer sink=new OutputStreamWriter(buffer);
    Enumeration terms=glossary.getGlossary(request).keys();
    // System.err.println("Read glossary terms");
    root=new MultiSearchReader(terms,false,sink);
    // root.dump(0);

    try 
      {
      boolean inTag=false;

      // Skip the header
      int numMatched=0;
      int headMatched=0;
      while(numMatched<4) 
        {
        char candidate=(char)cookedSource.read();
        sink.write(candidate);
        candidate=Character.toLowerCase(candidate);
        if(candidate=='<' && !inTag) inTag=true;
        if(candidate=='>' && inTag) inTag=false;
        if(candidate=="body".charAt(numMatched) && inTag) numMatched++;
        else numMatched=0;
        if(candidate=="head".charAt(headMatched) && inTag) headMatched++;
        else headMatched=0;
        if(headMatched==4) 
          {
          candidate=(char)cookedSource.read();
          sink.write(candidate);
          sink.write("<STYLE TYPE=\"text/css\">\n");
          sink.write("A.glossary:link { color: red }\n");
          sink.write("</STYLE>\n");
          } 
        }

      MultiSearchResult match=new MultiSearchResult(-1," ");
      start=0;
      while(match!=null)
        {
        match=root.search(match.getOffset()+match.getMatch().length(),cookedSource);
        // System.err.println("Got match "+match);
        if(root.getTagStatus()==MultiSearchReader.INSIDE_TAG && match!=null)
          {
          sink.write(match.getMatch());
          continue;
          }
        if(match!=null)
          {
          sink.write("<A CLASS=glossary HREF=\"");
          sink.write(glossary.getURL(request).toString());
          sink.write("?term=");
          sink.write(URLEncoder.encode(match.getMatch()));
          sink.write("\">");
          sink.write(match.getMatch());
          sink.write("</a>");
          }
        }
      sink.close();
      
      reply.setContentLength(buffer.size());
      reply.setStream(new ByteArrayInputStream(buffer.toByteArray()));
      } 
    catch(Exception e) 
      {
      Reply error = request.makeReply(HTTP.BAD_REQUEST) ;
      error.setContent("Invalid request: unable to read glossary data, error "+e);
      throw new HTTPException (error) ;
      }
    return;
    }
  }


