/* Httpd.java */

/* 
 * Copyright (C) 1997 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin;

import java.io.InputStream;
import java.io.ByteArrayInputStream;
import java.util.Enumeration;
import java.util.Date;
import java.util.TimeZone;
import java.util.StringTokenizer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.text.ParsePosition;
import java.net.Socket;

class Httpd extends HttpRelay
{
    static Options options = null;
    static FilterManager manager = null;
    
    Socket socket = null;
    Request request = null;
    
    Httpd (Socket socket)
    {
	super ();
	this.socket = socket;
    }
    
    public void write (Request request) throws java.io.IOException
    {
	this.request = request;
    }

    String decode (String str)
    {
	StringBuffer buf = new StringBuffer ();
	for (int i = 0; i < str.length (); i++)
	{
	    int ch = str.charAt (i);
	    if (ch == '+')
	    {
		buf.append (" ");
	    }
	    else if (ch == '%')
	    {
		try
		{
		    int val = Integer.parseInt (str.substring (i+1, i+3), 16);
		    buf.append ((char)val);
		}
		catch (Exception e)
		{
		}
		i+=2;
	    }
	    else
	    {
		buf.append ((char)ch);
	    }
	}
	return buf.toString ();
    }

    String getDateString ()
    {
	String str;
	
	SimpleDateFormat format = (SimpleDateFormat) DateFormat.getDateInstance ();
	format.applyPattern ("EEE, dd MMM yyyy HH:mm:ss z");
	TimeZone tz = TimeZone.getDefault ();
	format.setTimeZone (tz.getTimeZone ("GMT"));
	str = format.format (new Date ());
	
	return str;
    }

    String getInfo ()
    {
	StringBuffer html = new StringBuffer ();

	html.append ("<title>Muffin Admin</title><body>\n");
	html.append ("<h1>Muffin ");
	html.append (options.get ("muffin.version"));
	html.append (" on " + options.get ("muffin.host") + " port " + options.get ("muffin.port"));
	html.append ("</h1>\n");

	html.append ("<hr>\n");
	html.append ("<table><tr><td>\n");
	
	html.append ("<a name=\"Known Filters\"><h1>Known Filters</h1></a>\n");
	html.append ("<form method=POST action=/bin/enable>\n");
	html.append ("<select size=10 name=filter>\n");
	for (int i = 0; i < manager.knownFilters.size (); i++)
	{
	    html.append ("<option>" + (String) manager.knownFilters.elementAt (i) + "\n");
	}
	html.append ("</select>\n");
	html.append ("<br><input type=submit value=Enable>\n");
	html.append ("</form>\n");
	
	html.append ("</td><td>\n");

	html.append ("<a name=\"Enabled Filters\"><h1>Enabled Filters</h1></a>\n");
	html.append ("<form method=POST action=/bin/disable>\n");
	html.append ("<select size=10 name=index>\n");
	for (int i = 0; i < manager.enabledFilters.size (); i++)
	{
	    FilterFactory ff = (FilterFactory) manager.enabledFilters.elementAt (i);
	    String filter = (ff.getClass ()).getName ();
	    html.append ("<option value=" + i + ">" + filter + "\n");
	}
	html.append ("</select>\n");
	html.append ("<br>");
	html.append ("<input type=submit value=Disable>\n");
	html.append ("</form>\n");

	html.append ("</td></tr></table>\n");

	for (int i = 0; i < manager.enabledFilters.size (); i++)
	{
	    FilterFactory ff = (FilterFactory) manager.enabledFilters.elementAt (i);
	    String filter = (ff.getClass ()).getName ();
	    Prefs prefs = ff.getPrefs ();

	    html.append ("<hr>\n");
	    html.append ("<a name=\"" + filter + "\"><h1>" + filter + "</h1></a>\n");
	    if (prefs.isEmpty ())
	    {
		html.append ("No Preferences.\n");
		continue;
	    }
	    
	    html.append ("<form method=POST action=/bin/set>\n");
	    html.append ("<input type=hidden name=filter value=\"" + filter + "\">\n");
	    html.append ("<table>\n");
	    Enumeration e = prefs.sortedKeys ();
	    while (e.hasMoreElements ())
	    {
		String key = (String) e.nextElement ();
		String value = (String) prefs.get (key);
		html.append ("<tr><td>" + key + "</td>");
		html.append ("<td><input name=\"" + key + "\" size=" + value.length () + " type=text value=\"" + value + "\"></input></td></tr>\n");
	    }
	    html.append ("</table>\n");
	    html.append ("<br><input type=submit value=Submit><input type=reset value=Reset>\n");
	    html.append ("</form>\n");
	}
	
	html.append ("<hr>\n");
	html.append ("<a name=\"Virtual Machine\"><h1>Virtual Machine</h1></a>\n");
	html.append ("<table>\n");
	html.append ("<tr><td>java.version</td><td>" + System.getProperty ("java.version") + "</td></tr>\n");
	html.append ("<tr><td>java.class.version</td><td>" + System.getProperty ("java.class.version") + "</td></tr>\n");
	html.append ("<tr><td>java.class.path</td><td>" + System.getProperty ("java.class.path") + "</td></tr>\n");
	html.append ("<tr><td>java.home</td><td>" + System.getProperty ("java.home") + "</td></tr>\n");
	html.append ("<tr><td>java.vendor</td><td>" + System.getProperty ("java.vendor") + "</td></tr>\n");
	html.append ("<tr><td>os.version</td><td>" + System.getProperty ("os.version") + "</td></tr>\n");
	html.append ("<tr><td>os.arch</td><td>" + System.getProperty ("os.arch") + "</td></tr>\n");
	html.append ("<tr><td>os.name</td><td>" + System.getProperty ("os.name") + "</td></tr>\n");
	html.append ("<tr><td>user.name</td><td>" + System.getProperty ("user.name") + "</td></tr>\n");
	html.append ("<tr><td>user.dir</td><td>" + System.getProperty ("user.dir") + "</td></tr>\n");
	html.append ("<tr><td>user.home</td><td>" + System.getProperty ("user.home") + "</td></tr>\n");
	html.append ("</table>\n");

	html.append ("</body>\n");
	return html.toString ();
    }

    public Reply read () throws java.io.IOException
    {
	Reply reply = new Reply ();

	reply.setHeaderField ("Server", "Muffin/" + options.getString ("muffin.version"));
	reply.setHeaderField ("Date", getDateString ());
	
	if (request.getPath ().startsWith ("/images/"))
	{
	    String path = request.getPath ().substring (1);
	    InputStream content = getClass ().getResourceAsStream (path);
	    reply.statusLine = "HTTP/1.0 200 Ok";
	    reply.setHeaderField ("Content-type", "image/jpeg");
	    in = content;
	}
	else if (!options.adminAccess (socket.getInetAddress ()))
	{
	    HttpError error = new HttpError (options, 403, "Administrative access denied");
	    reply = error.getReply ();
	    in = (InputStream) new ByteArrayInputStream (error.getContent ().getBytes ());
	}
	else if (request.getPath ().equals ("/"))
	{
	    byte buf[] = getInfo ().getBytes ();
	    reply.statusLine = "HTTP/1.0 200 Ok";
	    reply.setHeaderField ("Content-type", "text/html");
	    reply.setHeaderField ("Content-length", Integer.toString (buf.length));
	    in = (InputStream) new ByteArrayInputStream (buf);
	}
	else if (request.getPath ().startsWith ("/images/"))
	{
	    String path = request.getPath ().substring (1);
	    InputStream content = getClass ().getResourceAsStream (path);
	    reply.statusLine = "HTTP/1.0 200 Ok";
	    reply.setHeaderField ("Content-type", "image/gif");
	    in = content;
	}
	else if (request.getPath ().equals ("/bin/enable"))
	{
	    StringTokenizer st = new StringTokenizer (decode (request.getData ()), "&");
	    while (st.hasMoreTokens ())
	    {
		String token = st.nextToken ();
		String key = token.substring (0, token.indexOf ('='));
		String value = token.substring (token.indexOf ('=') + 1);
		if (key.equals ("filter"))
		{
		    manager.enable (value);
		}
	    }
 	    reply.statusLine = "HTTP/1.0 302 Moved Temporarily";
 	    reply.setHeaderField ("Location", getLocation () + "/");
 	    byte buf[] = new String ("Document Moved").getBytes ();
 	    in = (InputStream) new ByteArrayInputStream (buf);
	}
	else if (request.getPath ().equals ("/bin/disable"))
	{
	    StringTokenizer st = new StringTokenizer (decode (request.getData ()), "&");
	    while (st.hasMoreTokens ())
	    {
		String token = st.nextToken ();
		String key = token.substring (0, token.indexOf ('='));
		String value = token.substring (token.indexOf ('=') + 1);
		if (key.equals ("index"))
		{
		    try
		    {
			int index = Integer.parseInt (value);
			manager.disable (index);
		    }
		    catch (Exception e)
		    {
		    }
		}
	    }
 	    reply.statusLine = "HTTP/1.0 302 Moved Temporarily";
 	    reply.setHeaderField ("Location", getLocation () + "/");
 	    byte buf[] = new String ("Document Moved").getBytes ();
 	    in = (InputStream) new ByteArrayInputStream (buf);
	}
	else if (request.getPath ().equals ("/bin/set"))
	{
	    FilterFactory factory = null;
	    StringTokenizer st = new StringTokenizer (decode (request.getData ()), "&");
	    while (st.hasMoreTokens ())
	    {
		String token = st.nextToken ();
		String key = token.substring (0, token.indexOf ('='));
		String value = token.substring (token.indexOf ('=') + 1);
		if (key.equals ("filter"))
		{
		    for (int i = 0; i < manager.enabledFilters.size (); i++)
		    {
			FilterFactory ff = (FilterFactory) manager.enabledFilters.elementAt (i);
			String filter = (ff.getClass ()).getName ();
			if (filter.equals (value))
			{
			    factory = ff;
			    break;
			}
		    }
		}
		else if (factory != null)
		{
		    Prefs prefs = factory.getPrefs ();
		    prefs.put (key, value);
		}
	    }
 	    reply.statusLine = "HTTP/1.0 302 Moved Temporarily";
 	    reply.setHeaderField ("Location", getLocation () + "/");
 	    byte buf[] = new String ("Document Moved").getBytes ();
 	    in = (InputStream) new ByteArrayInputStream (buf);
	}
	else
	{
	    HttpError error = new HttpError (options, 404, request.getPath () + " not found");
	    reply = error.getReply ();
	    in = (InputStream) new ByteArrayInputStream (error.getContent ().getBytes ());
	}

	return reply;
    }

    static void init (Options o, FilterManager m)
    {
	options = o;
	manager = m;
    }

    static boolean sendme (Request request)
    {
	return request.getHost ().equalsIgnoreCase (options.getString ("muffin.host"))
	    && request.getPort () == options.getInteger ("muffin.port");
    }
    
    static String getLocation ()
    {
	StringBuffer buf = new StringBuffer ();
	buf.append ("http://");
	buf.append (options.getString ("muffin.host"));
	buf.append (":");
	buf.append (options.getString ("muffin.port"));
	return buf.toString ();
    }
}
