/* Glossary.java */

package muffin.filter;

import java.io.*;
import java.util.Enumeration;
import UK.co.demon.asmodeus.util.*;
import muffin.*;

public class GlossaryFilter implements ContentFilter
{
    Prefs prefs;
    Glossary factory;
    InputStream in = null;
    OutputStream out = null;

    public GlossaryFilter (Glossary factory)
    {
	this.factory = factory;
    }

    public void setPrefs (Prefs prefs)
    {
	this.prefs = prefs;
    }
    
    public boolean needsFiltration (Request request, Reply reply)
    {
	String s = reply.getHeaderField ("Content-type");
	return s != null && s.startsWith ("text/html");
    }

    public void setInputStream (InputStream in)
    {
	this.in = in;
    }

    public void setOutputStream (OutputStream out)
    {
	this.out = out;
    }

    public void run ()
    {
	ByteArrayOutputStream htmlbuf = new ByteArrayOutputStream ();
	try
	{
	    byte buf[] = new byte[1024];
	    int n;
	    while ((n = in.read (buf, 0, buf.length)) > 0)
	    {
		htmlbuf.write (buf, 0, n);
	    }
	    htmlbuf.close ();
	}
	catch (Exception e)
	{
	}
	ByteArrayInputStream html = new ByteArrayInputStream (htmlbuf.toByteArray ());


	MultiSearchReader root;
	int start;
	BufferedReader cookedSource=new BufferedReader(new InputStreamReader(html));
	ByteArrayOutputStream buffer=new ByteArrayOutputStream();
	Writer sink=new OutputStreamWriter(buffer);
	Enumeration terms=factory.keys();
	root=new MultiSearchReader(terms,false,sink);

	try 
	{
	    MultiSearchResult match=new MultiSearchResult(-1," ");
	    start=0;
	    while(match!=null)
	    {
		match=root.search(match.getOffset()+match.getMatch().length(),cookedSource);
		if(root.getTagStatus()==MultiSearchReader.INSIDE_TAG && match!=null)
		{
		    sink.write(match.getMatch());
		    continue;
		}
		if(match!=null)
		{
		    sink.write ("<a href=\"");
		    sink.write (factory.lookup (match.getMatch ()));
		    sink.write ("\">");
		    sink.write (match.getMatch());
		    sink.write ("</a>");
		}
	    }
	    sink.close ();
	    buffer.writeTo (out);
	    out.flush ();
	    out.close ();
	} 
	catch(Exception e) 
	{
	    e.printStackTrace ();
	}
    }
}


