/* NoThanksFrame.java */

/* 
 * Copyright (C) 1997 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin.filter;

import java.awt.*;
import java.awt.event.*;
import muffin.*;

public class NoThanksFrame extends Frame implements ActionListener, WindowListener
{
    Prefs prefs;
    NoThanks parent;
    TextField input = null;
    TextArea text;
    
    public NoThanksFrame (Prefs prefs, NoThanks parent)
    {
	super ("NoThanks");

	this.prefs = prefs;
	this.parent = parent;

	setBackground (Color.lightGray);
	setFont (new Font ("Helvetica", Font.BOLD, 12));

	Panel panel = new Panel ();
	GridBagLayout layout = new GridBagLayout ();
        panel.setLayout (layout);
	GridBagConstraints c;
	
	panel.add (new Label ("Kill File:", Label.RIGHT));

	input = new TextField (50);
	input.setText (prefs.getString ("NoThanks.killfile"));
	panel.add (input);

	Button browse = new Button ("Browse...");
	browse.setActionCommand ("doBrowse");
	browse.addActionListener (this);
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (browse, c);
	panel.add (browse);

	text = new TextArea ();
	text.setEditable (false);
	c = new GridBagConstraints ();
	c.fill = GridBagConstraints.BOTH;
	c.anchor = GridBagConstraints.NORTHWEST;
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (text, c);
	panel.add (text);
	
	add ("Center", panel);

	Panel buttonPanel = new Panel ();
	buttonPanel.setLayout (new GridLayout (1, 4));
	Button b;
	b = new Button ("Apply");
	b.setActionCommand ("doApply");
	b.addActionListener (this);
	buttonPanel.add (b);
	b = new Button ("Save");
	b.setActionCommand ("doSave");
	b.addActionListener (this);
	buttonPanel.add (b);
	b = new Button ("Reload File");
	b.setActionCommand ("doReload");
	b.addActionListener (this);
	buttonPanel.add (b);
	b = new Button ("Clear");
	b.setActionCommand ("doClear");
	b.addActionListener (this);
	buttonPanel.add (b);
	b = new Button ("Close");
	b.setActionCommand ("doClose");
	b.addActionListener (this);
	buttonPanel.add (b);
	add ("South", buttonPanel);

	addWindowListener (this);
	
	pack ();
	setSize (getPreferredSize ());

	show ();
    }

    public void actionPerformed (ActionEvent event)
    {
	String arg = event.getActionCommand ();
	
	if ("doApply".equals (arg))
	{
	    prefs.putString ("NoThanks.killfile", input.getText ());
	}
	else if ("doSave".equals (arg))
	{
	    parent.save ();
	}
	else if ("doReload".equals (arg))
	{
	    parent.load ();
	}
	else if ("doClear".equals (arg))
	{
	    text.setText ("");
	}
	else if ("doClose".equals (arg))
	{
	    setVisible (false);
	}
	else if ("doBrowse".equals (arg))
	{
	    FileDialog dialog = new FileDialog (this, "NoThanks Load");
	    dialog.show ();
	    if (dialog.getFile () != null)
	    {
		input.setText (dialog.getDirectory () + dialog.getFile ());
	    }
	}
    }

    public void windowActivated (WindowEvent e)
    {
    }
  
    public void windowDeactivated (WindowEvent e)
    {
    }
  
    public void windowClosing (WindowEvent e)
    {
	setVisible (false);
    }
  
    public void windowClosed (WindowEvent e)
    {
    }
  
    public void windowIconified (WindowEvent e)
    {
    }
  
    public void windowDeiconified (WindowEvent e)
    {
    }
  
    public void windowOpened (WindowEvent e)
    {
    }
}
