/* TestFilter.java */

/* 
 * Copyright (C) 1997 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin.filter;

import muffin.*;
import muffin.html.*;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;

public class TestFilter implements ContentFilter
{
    Prefs prefs;
    Test factory;
    InputStream in = null;
    OutputStream out = null;
    Reply reply;
    Request request;

    public TestFilter (Test factory)
    {
	this.factory = factory;
    }
    
    public void setPrefs (Prefs prefs)
    {
	this.prefs = prefs;
    }

    public boolean needsFiltration (Request request, Reply reply)
    {
	this.request = request;
	this.reply = reply;
	
	String s = reply.getHeaderField ("Content-type");
	return s != null && s.startsWith ("text/html");
    }
    
    public void setInputStream (InputStream in)
    {
	this.in = in;
    }

    public void setOutputStream (OutputStream out)
    {
	this.out = out;
    }
    
    public void xrun ()
    {
	try
	{
	    int c;
	    while ((c = in.read ()) != -1)
	    {
		out.write (c);
	    }
	    out.flush ();
	    out.close ();
	}
	catch (Exception e)
	{
	    e.printStackTrace ();
	}
    }

    public void run ()
    {
	try
	{
	    HtmlTokenizer html = new HtmlTokenizer (in);
	    int token;

            while ((token = html.getToken ()) != HtmlTokenizer.TT_EOF)
            {
		if (token == HtmlTokenizer.TT_TAG)
		{
		    Tag tag = html.getTag ();
		}
		html.writeToken (out);
	    }

	    out.flush ();
	    out.close ();
	}
	catch (Exception e)
	{
	    e.printStackTrace ();
	}
    }
}
