/*
 * Decompiled with CFR 0.152.
 */
package muffin;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.StringReader;
import java.util.Enumeration;
import muffin.BigList;
import muffin.Configuration;
import muffin.ConfigurationListener;
import muffin.TextDialog;
import muffin.YesNoDialog;

class ConfigurationFrame
extends Frame
implements ActionListener,
ItemListener,
WindowListener,
ConfigurationListener {
    BigList configNamesList;
    Configuration configs;
    TextArea text;

    ConfigurationFrame(Configuration configuration) {
        super("Muffin: Configurations");
        this.configs = configuration;
        ((Component)this).setBackground(Color.lightGray);
        ((Component)this).setFont(new Font("Helvetica", 1, 12));
        this.setResizable(false);
        this.configNamesList = new BigList(10, false);
        Panel panel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        Label label = new Label();
        label.setFont(new Font("Fixed", 0, 12));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        Label label2 = new Label("Known Configurations");
        label2.setFont(new Font("Fixed", 1, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        panel.add(label2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.insets = new Insets(0, 10, 5, 10);
        gridBagLayout.setConstraints(this.configNamesList, gridBagConstraints);
        panel.add(this.configNamesList);
        Button button = new Button("New...");
        button.setActionCommand("doNew");
        button.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        panel.add(button);
        button = new Button("Select");
        button.setActionCommand("doSelect");
        button.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        panel.add(button);
        button = new Button("Rescan");
        button.setActionCommand("doRescan");
        button.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        panel.add(button);
        button = new Button("Delete");
        button.setActionCommand("doDelete");
        button.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        panel.add(button);
        label2 = new Label("Automatic Configuration");
        label2.setFont(new Font("Fixed", 1, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        panel.add(label2);
        button = new Button("Example");
        button.setActionCommand("doExample");
        button.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        panel.add(button);
        this.text = new TextArea(10, 40);
        this.text.setEditable(true);
        this.text.setFont(new Font("Fixed", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.text, gridBagConstraints);
        panel.add(this.text);
        this.add("Center", panel);
        Panel panel2 = new Panel();
        button = new Button("Apply");
        button.setActionCommand("doApply");
        button.addActionListener(this);
        panel2.add(button);
        button = new Button("Reload");
        button.setActionCommand("doReload");
        button.addActionListener(this);
        panel2.add(button);
        button = new Button("Save");
        button.setActionCommand("doSave");
        button.addActionListener(this);
        panel2.add(button);
        button = new Button("Close");
        button.setActionCommand("doClose");
        button.addActionListener(this);
        panel2.add(button);
        this.add("South", panel2);
        this.addWindowListener(this);
        this.updateConfigNamesList();
        this.loadAutoConfigFile();
        configuration.addConfigurationListener(label);
        configuration.addConfigurationListener(this);
        this.pack();
        ((Component)this).setSize(this.getPreferredSize());
    }

    public void configurationChanged(String string) {
        this.updateConfigNamesList();
    }

    void loadAutoConfigFile() {
        this.text.setText("");
        File file = new File(this.configs.getAutoConfigFile());
        if (!file.exists()) {
            return;
        }
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                this.text.append(String.valueOf(string) + "\n");
            }
            bufferedReader.close();
            return;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return;
        }
    }

    void updateConfigNamesList() {
        if (this.configNamesList.getItemCount() > 0) {
            this.configNamesList.removeAll();
        }
        Enumeration enumeration = this.configs.sortedKeys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.configNamesList.addItem(string);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("doClose".equals(string)) {
            ((Component)this).setVisible(false);
            return;
        }
        if ("doNew".equals(string)) {
            TextDialog textDialog = new TextDialog((Frame)this, "New configuration name:");
            textDialog.show();
            String string2 = textDialog.getAnswer();
            if (string2 != null && string2.length() > 0) {
                string2.trim();
                this.configs.createConfig(string2);
            }
            textDialog.dispose();
            return;
        }
        if ("doDelete".equals(string)) {
            String string3;
            int n = this.configNamesList.getSelectedIndex();
            if (n != -1 && this.configs.delete(string3 = this.configNamesList.getItem(n))) {
                this.updateConfigNamesList();
                YesNoDialog yesNoDialog = new YesNoDialog((Frame)this, "Delete the " + string3 + " file?");
                yesNoDialog.show();
                if (yesNoDialog.isYes()) {
                    this.configs.deleteUserConfigFile(string3);
                }
                yesNoDialog.dispose();
                return;
            }
        } else if ("doSelect".equals(string)) {
            int n = this.configNamesList.getSelectedIndex();
            if (n != -1) {
                this.configs.setCurrent(this.configNamesList.getItem(n));
                return;
            }
        } else {
            if ("doRescan".equals(string)) {
                this.configs.rescan();
                this.updateConfigNamesList();
                return;
            }
            if ("doReload".equals(string)) {
                this.configs.reload();
                return;
            }
            if ("doApply".equals(string)) {
                this.configs.load(new StringReader(this.text.getText()));
                return;
            }
            if ("doSave".equals(string)) {
                try {
                    File file = new File(this.configs.getAutoConfigFile());
                    if (file.exists()) {
                        file.delete();
                    }
                    FileWriter fileWriter = new FileWriter(file);
                    fileWriter.write(this.text.getText());
                    fileWriter.close();
                    return;
                }
                catch (Exception exception) {
                    System.out.println(exception);
                    return;
                }
            }
            if ("doExample".equals(string)) {
                this.text.setText("counter\t\t\tcounter.conf\n(cgi-bin|\\.cgi)\t\tcgi.conf\n^http://.*\\.sdsu\\.edu/\t\tsdsu.conf\n^http://.*\\.yahoo\\.com/\tyahoo.conf\n");
            }
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

