/*
 * Decompiled with CFR 0.152.
 */
package muffin.filter;

import muffin.ContentFilter;
import muffin.FilterException;
import muffin.Prefs;
import muffin.Reply;
import muffin.ReplyFilter;
import muffin.Request;
import muffin.RequestFilter;
import muffin.filter.NoThanks;
import muffin.html.Tag;
import muffin.html.Token;
import muffin.io.InputObjectStream;
import muffin.io.OutputObjectStream;

public class NoThanksFilter
implements ContentFilter,
RequestFilter,
ReplyFilter {
    NoThanks factory;
    Prefs prefs;
    InputObjectStream in;
    OutputObjectStream out;
    Request request;

    public NoThanksFilter(NoThanks noThanks) {
        this.factory = noThanks;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public void filter(Request request) throws FilterException {
        String string = request.getURL();
        String string2 = this.factory.redirect(string);
        if (string2 != null) {
            request.setURL(string2);
            return;
        }
        if (this.factory.isKilled(string)) {
            this.factory.process("Killed: " + string + "\n");
            throw new FilterException("NoThanks URL " + string + " rejected");
        }
    }

    public void filter(Reply reply) throws FilterException {
        String string = reply.getContentType();
        if (string != null && this.factory.killContent(string)) {
            this.factory.process("Killed: " + string + "\n");
            throw new FilterException("NoThanks content-type " + string + " rejected");
        }
    }

    public boolean needsFiltration(Request request, Reply reply) {
        this.request = request;
        String string = reply.getContentType();
        return string != null && string.startsWith("text/html");
    }

    public void setInputObjectStream(InputObjectStream inputObjectStream) {
        this.in = inputObjectStream;
    }

    public void setOutputObjectStream(OutputObjectStream outputObjectStream) {
        this.out = outputObjectStream;
    }

    public void run() {
        Thread.currentThread().setName("NoThanks");
        try {
            Object object;
            String string = null;
            boolean bl = false;
            block6: while ((object = this.in.read()) != null) {
                Token token = (Token)object;
                if (bl && token.getType() != -8) continue;
                switch (token.getType()) {
                    case -8: {
                        String string2 = token.toString();
                        bl = this.factory.killComment(string2);
                        if (bl) {
                            this.factory.process("Comment: " + string2 + "\n");
                            break;
                        }
                        this.out.write(token);
                        break;
                    }
                    case -2: {
                        boolean bl2 = true;
                        Tag tag = token.createTag();
                        if (string != null && tag.is(string)) {
                            string = null;
                            break;
                        }
                        if (this.factory.stripTag(tag.name())) {
                            this.factory.process("Stripped: " + tag.name() + "\n");
                            string = this.factory.stripUntil(tag.name());
                            bl2 = false;
                        } else if (this.factory.replaceTag(tag.name())) {
                            this.factory.process("Replaced: " + tag.name() + "\n");
                            tag = this.factory.replaceTagWith(tag.name());
                        } else if (this.factory.checkTagAttributes(tag)) {
                            if (this.factory.processTagAttributes(tag)) {
                                bl2 = false;
                            }
                        } else if (this.factory.checkTag(tag.name())) {
                            int n = 0;
                            while (n < this.factory.hyperlist.length) {
                                String string3;
                                if (tag.has(this.factory.hyperlist[n]) && this.factory.isKilled(string3 = tag.get(this.factory.hyperlist[n]))) {
                                    this.factory.process("Killed: " + string3 + "\n");
                                    bl2 = false;
                                    if (tag.is("a")) {
                                        string = "/a";
                                        break;
                                    }
                                    if (tag.is("form")) {
                                        string = "/form";
                                        break;
                                    }
                                    if (tag.is("iframe")) {
                                        string = "/iframe";
                                        break;
                                    }
                                    if (!tag.is("layer")) break;
                                    string = "/layer";
                                    break;
                                }
                                ++n;
                            }
                        }
                        if (!bl2) continue block6;
                        token.importTag(tag);
                        this.out.write(token);
                        break;
                    }
                    default: {
                        if (string != null) continue block6;
                        this.out.write(token);
                    }
                }
            }
            this.out.flush();
            this.out.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

