/* Token.java */

/* 
 * Copyright (C) 1996-98 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin.html;

import muffin.io.*;

public class Token extends ByteArray
{
    public static final int TT_NONE = -1;
    public static final int TT_EOF = -1;
    public static final int TT_TAG = -2;
    public static final int TT_TEXT = -4;
    public static final int TT_COMMENT = -8;

    protected int type = TT_NONE;

    private Tag cachedTag = null;

    public Token ()
    {
    }

    public Token (int type)
    {
	this.type = type;
    }

    public int getType ()
    {
	return type;
    }

    public Tag createTag ()
    {
	if (cachedTag != null)
	{
	    return cachedTag;
	}
	
	int start = 0, end = 0, rest = 0;

	while (start < offset)
	{
	    switch (bytes[++start])
	    {
	    case ' ':
	    case '\t':
	    case '\r':
	    case '\n':
	    case '>':
		continue;
	    }
	    break;
	}

	end = start;
 loop:  while (end < offset)
	{
	    switch (bytes[++end])
	    {
	    case ' ':
	    case '\t':
	    case '\r':
	    case '\n':
		rest = end+1;
		break loop;
		
	    case '>':
		rest = -1;
		break loop;
	    }
	}

	String name = new String (bytes, start, end - start).toLowerCase ();
	String data = null;
	if (rest > 0 && offset - rest -1 > 0)
	{
	    data = new String (bytes, rest, offset - rest - 1);
	}

	cachedTag = new Tag (name, data);
	return cachedTag;
    }

    public void importTag (Tag newTag)
    {
	if (newTag.isModified ())
	{
	    bytes = newTag.toString ().getBytes ();
	    offset = bytes.length;
	    cachedTag = newTag;
	}
    }
}
