package UK.co.demon.asmodeus.jigsaw;

import java.lang.*;
import java.util.*;
import java.net.*;
import java.io.*;

import w3c.jigsaw.resources.*;
import w3c.jigsaw.http.*;
import w3c.www.http.*;
import w3c.jigsaw.forms.*;
import w3c.jigsaw.html.*;
import w3c.tools.store.*;

//
// $Log: GlossaryResource.java,v $
// Revision 2.0  1997/06/02 21:18:09  joel
// First version of the resource after the new updates.
//
// Revision 1.2  1997/02/20 14:41:14  joel
// Cleanup and commented out prints.
//
// Revision 1.1  1997/02/20 14:37:05  joel
// Initial revision
//

public class GlossaryResource extends PostableResource 
  {
  public static final String RCSID="$Id: GlossaryResource.java,v 2.0 1997/06/02 21:18:09 joel Exp $";

  /**
   * glossary is the hashtable holding the terms and definitions.
   */
  Hashtable glossary=null;

  /** 
   * Handle a post to this resource. Get is passed through and just
   * returns the entire glossary raw.
   */ 
  public Reply handle(Request request,URLDecoder data) throws HTTPException
    {
    if(data.getValue("term")==null) 
      {
      Reply error = request.makeReply(HTTP.BAD_REQUEST) ;
      error.setContent("Invalid request:No glossary term.");
      throw new HTTPException (error) ;
      }

    getGlossary(request);

    Reply reply = request.makeReply(HTTP.OK);
    HtmlGenerator g=new HtmlGenerator("Definition for "+data.getValue("term"));
    g.append("<h1>"+data.getValue("term")+"</H1>");
    g.append("<P>"+glossary.get(data.getValue("term").toLowerCase())+"</p>");

    if(request.getReferer()!=null) 
      {
      g.append("<HR><A HREF=\""+request.getReferer()+"\">Back to document</A>");
      }

    reply.setStream(g);
    return reply;
    }

  /**
   * Load the glossary from the file 
   */
  public Hashtable getGlossary(Request request) throws HTTPException
    {
    // System.err.println("getGlossary called");
    if(glossary==null)
      {
      File glossaryFile=null;
      if((glossaryFile=getFile())==null) 
	     {
        Reply error = request.makeReply(HTTP.BAD_REQUEST) ;
        error.setContent("Invalid request:No glossary file specified.");
        throw new HTTPException (error) ;
        }    
      if(!glossaryFile.isFile())
        {
        Reply error = request.makeReply(HTTP.BAD_REQUEST) ;
        error.setContent("Invalid request:Glossary file does not exist.");
        throw new HTTPException (error) ;
        }
      BufferedReader source=null;
      try
        {
        source=new BufferedReader(new FileReader(glossaryFile));
        } 
      catch(Exception e) 
        {
        Reply error = request.makeReply(HTTP.BAD_REQUEST) ;
        error.setContent("Invalid request:Glossary exception "+e);
        throw new HTTPException (error) ;
        }	
      String line;
      try 
        {
        while((line=source.readLine())!=null) 
          {
          if(line.startsWith("START")) break;
          }
        if(line==null)
          {
          Reply error = request.makeReply(HTTP.BAD_REQUEST) ;
          error.setContent("Invalid request:Glossary file does not contain START line.");
          throw new HTTPException (error) ;
          }
        glossary=new Hashtable();
        // System.err.println("Got past the START line");
        while((line=source.readLine())!=null)
          {
          if(line.startsWith("END")) break;
          String term=line.trim();
          // System.err.println("term = "+term);
          StringBuffer defn=new StringBuffer();
          while((line=source.readLine())!=null)
            {
            if(line.startsWith("$$$")) break;
            defn.append(" ");
            defn.append(line);
            }
          if(term!=null && !term.equals("")) glossary.put(term.toLowerCase(),defn.toString());
	  //          System.err.println("Loaded glossary term "+term);
          }
        }
      catch(Exception e2)
        {
        Reply error = request.makeReply(HTTP.BAD_REQUEST) ;
        error.setContent("Invalid request:Glossary exception 2 "+e2);
        throw new HTTPException (error) ;
        }
      } 
    return glossary; 
    }  
  }
