/* RegexFrame.java */

/* 
 * Copyright (C) 1996-98 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin;

import java.awt.Button;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;
import java.util.Enumeration;

import JP.ac.osaka_u.ender.util.regex.*;

/**
 * @author Mark Boyns
 */
class RegexFrame extends Frame implements ActionListener, WindowListener
{
    TextArea text;
    TextField pattern;
    MatchInfo info = null;

    RegexFrame ()
    {
	super ("Muffin: Regular Expression Tester");

	setBackground (Color.lightGray);
	setFont (new Font ("Helvetica", Font.BOLD, 12));

	Button b;
	Panel panel = new Panel ();
	GridBagLayout layout = new GridBagLayout ();
        panel.setLayout (layout);
	GridBagConstraints c;
	
	Label l = new Label ("Regular Expression:", Label.RIGHT);
	panel.add (l);

	pattern = new TextField (32);
	panel.add (pattern);

	b = new Button ("Match");
	b.setActionCommand ("doMatch");
	b.addActionListener (this);
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (b, c);
	panel.add (b);

	add ("North", panel);
	
	text = new TextArea ();
	text.setEditable (true);
	text.setFont (new Font ("Fixed", Font.PLAIN, 12));
	text.setText ("Insert sample text here...");
	add ("Center", text);

	Panel buttonPanel = new Panel ();
	buttonPanel.setLayout (new GridLayout (1, 2));
	b = new Button ("Clear");
	b.setActionCommand ("doClear");
	b.addActionListener (this);
	buttonPanel.add (b);
	b = new Button ("Close");
	b.setActionCommand ("doClose");
	b.addActionListener (this);
	buttonPanel.add (b);
	add ("South", buttonPanel);

	addWindowListener (this);

	pack ();
	setSize (getPreferredSize ());
	show ();
    }

    public void actionPerformed (ActionEvent event)
    {
	String arg = event.getActionCommand ();

	if ("doClose".equals (arg))
	{
	    setVisible (false);
	}
	else if ("doClear".equals (arg))
	{
	    text.setText ("");
	}
	else if ("doMatch".equals (arg))
	{
	    try
	    {
		RegExp regexp = new RegExp (pattern.getText ());

		if (info != null)
		{
		    info = regexp.match (text.getText (), info.end (), text.getText ().length ());
		}
		else
		{
		    info = regexp.match (text.getText ());
		}
		
		if (info != null)
		{
		    text.select (info.start (), info.end ());
		}
	    }
	    catch (Exception e)
	    {
		System.out.println (e);
	    }
	}
    }

    public void windowActivated (WindowEvent e)
    {
    }
  
    public void windowDeactivated (WindowEvent e)
    {
    }
  
    public void windowClosing (WindowEvent e)
    {
	setVisible (false);
    }
  
    public void windowClosed (WindowEvent e)
    {
    }
  
    public void windowIconified (WindowEvent e)
    {
    }
  
    public void windowDeiconified (WindowEvent e)
    {
    }
  
    public void windowOpened (WindowEvent e)
    {
    }
}
