/* Secretary.java  */

/* 
 * Copyright (C) 1997 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin.filter;

import muffin.*;
import muffin.html.*;

// possible overhead

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

// changed

import java.util.Vector;
import java.util.Hashtable;
import java.util.Enumeration;


public class Secretary extends Hashtable implements FilterFactory
{
  FilterManager manager;
  Prefs prefs;
  SecretaryFrame frame = null;

  // Hash that contains the name of the field (key) and the new value of
  // the input field
  Hashtable Values;
  // Hash that contains the alias (key) and the name of the attribute
  Hashtable Lockup;
  // Vector contains all known aliases
  Vector Aliases;

  

  
  public Secretary ()
  {
    super (33);

    // set a initial size for all attributes
    Values = new Hashtable(20);
    // the other sizes depends on it
    Lockup = new Hashtable(60);
    Aliases = new Vector(60);
  }

  public void setManager (FilterManager manager)
  {
    this.manager = manager;
  }
    
  public void setPrefs (Prefs prefs)
  {
    this.prefs = prefs;

    // read the name of the attributes
    String Names[] = prefs.getStringList("Secretary.Names");
    for (int n = 0; n < Names.length; n++) {
      // read the value for this attribute
      Values.put(Names[n].toLowerCase(), prefs.getString("Secretary." + Names[n]));
      // read all aliases for this attribute
      String Alias[] = prefs.getStringList("Secretary.Aliases." + Names[n]);
      for (int a = 0; a < Alias.length; a++) {
	// add the aliases to the lockup hash and the unique vector
	Lockup.put(Alias[a].toLowerCase(), Names[n].toLowerCase());
	Aliases.addElement(Alias[a].toLowerCase());
      }
    }


    boolean o = prefs.getOverride ();
    prefs.setOverride (false);
    String filename = prefs.getUserFile ("formfile.dat");
    prefs.putString ("Secretary.formfile", filename);
    prefs.setOverride (o);
    load ();
  }

  public Prefs getPrefs ()
  {
    return prefs;
  }

  public void viewPrefs ()
  {
    if (frame == null)
      {
	frame = new SecretaryFrame (prefs, this);
      }
    frame.setVisible (true);
  }
    
  public Filter createFilter ()
  {
    Filter f = new SecretaryFilter (this);
    f.setPrefs (prefs);
    return f;
  }

  void save ()
  {
    manager.save (this);
  }

  void load ()
  {
    String filename = prefs.getString ("Secretary.formfile");
    System.out.println ("Secretary loading " + filename);
    File file = new File (filename);
    if (!file.exists ())
      {
	System.out.println ("Secretary can't open " + filename);
	return;
      }
    try
      {
	FileInputStream in = new FileInputStream (file);
	Properties props = new Properties ();
	props.load (in);
	Enumeration e = props.keys ();
	while (e.hasMoreElements ())
	  {
	    String key = (String) e.nextElement ();
	    put (key, props.get (key));
	  }
	in.close ();
      }
    catch (Exception e)
      {
	e.printStackTrace ();
      }
  }
}

