/*
 * Decompiled with CFR 0.152.
 */
package gnu.getopt;

import gnu.getopt.LongOpt;

public class Getopt {
    protected static final int REQUIRE_ORDER = 1;
    protected static final int PERMUTE = 2;
    protected static final int RETURN_IN_ORDER = 3;
    public String optarg;
    public int optind;
    public boolean opterr = true;
    public int optopt = 63;
    protected String nextchar;
    protected String optstring;
    protected LongOpt[] long_options;
    protected boolean long_only;
    protected int longind;
    protected boolean posixly_correct;
    protected boolean longopt_handled;
    protected int first_nonopt = 1;
    protected int last_nonopt = 1;
    protected String[] argv;
    protected int ordering;
    protected String progname;

    public Getopt(String string, String[] stringArray, String string2) {
        this(string, stringArray, string2, null, false);
    }

    public Getopt(String string, String[] stringArray, String string2, LongOpt[] longOptArray) {
        this(string, stringArray, string2, longOptArray, false);
    }

    public Getopt(String string, String[] stringArray, String string2, LongOpt[] longOptArray, boolean bl) {
        this.progname = string;
        this.argv = stringArray;
        this.optstring = string2;
        this.long_options = longOptArray;
        this.long_only = bl;
        this.posixly_correct = System.getProperty("gnu.posixly_correct", null) != null;
        if (string2.charAt(0) == '-') {
            this.ordering = 3;
            if (string2.length() > 1) {
                this.optstring = string2.substring(1);
                return;
            }
        } else if (string2.charAt(0) == '+') {
            this.ordering = 1;
            if (string2.length() > 1) {
                this.optstring = string2.substring(1);
                return;
            }
        } else {
            if (this.posixly_correct) {
                this.ordering = 1;
                return;
            }
            this.ordering = 2;
        }
    }

    public void setOptstring(String string) {
        this.optstring = string;
    }

    public int getOptind() {
        return this.optind;
    }

    public void setOptind(int n) {
        this.optind = n;
    }

    public void setArgv(String[] stringArray) {
        this.argv = stringArray;
    }

    public String getOptarg() {
        return this.optarg;
    }

    public void setOpterr(boolean bl) {
        this.opterr = bl;
    }

    public int getOptopt() {
        return this.optopt;
    }

    public int getLongind() {
        return this.longind;
    }

    protected void exchange(String[] stringArray) {
        int n = this.first_nonopt;
        int n2 = this.last_nonopt;
        int n3 = this.optind;
        while (n3 > n2 && n2 > n) {
            String string;
            int n4;
            int n5;
            if (n3 - n2 > n2 - n) {
                n5 = n2 - n;
                n4 = 0;
                while (n4 < n5) {
                    string = stringArray[n + n4];
                    stringArray[n + n4] = stringArray[n3 - (n2 - n) + n4];
                    stringArray[n3 - (n2 - n) + n4] = string;
                    ++n4;
                }
                n3 -= n5;
                continue;
            }
            n5 = n3 - n2;
            n4 = 0;
            while (n4 < n5) {
                string = stringArray[n + n4];
                stringArray[n + n4] = stringArray[n2 + n4];
                stringArray[n2 + n4] = string;
                ++n4;
            }
            n += n5;
        }
        this.first_nonopt += this.optind - this.last_nonopt;
        this.last_nonopt = this.optind;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int checkLongOption() {
        LongOpt longOpt;
        block21: {
            longOpt = null;
            this.longopt_handled = true;
            boolean bl = false;
            boolean bl2 = false;
            this.longind = -1;
            int n = this.nextchar.indexOf("=");
            if (n == -1) {
                n = this.nextchar.length();
            }
            int n2 = 0;
            while (n2 < this.long_options.length) {
                if (this.long_options[n2].getName().startsWith(this.nextchar.substring(0, n))) {
                    if (this.long_options[n2].getName().equals(this.nextchar.substring(0, n))) {
                        longOpt = this.long_options[n2];
                        this.longind = n2;
                        bl2 = true;
                        break;
                    }
                    if (longOpt == null) {
                        longOpt = this.long_options[n2];
                        this.longind = n2;
                    } else {
                        bl = true;
                    }
                }
                ++n2;
            }
            if (bl && !bl2) {
                if (this.opterr) {
                    System.err.print(String.valueOf(this.progname) + ": option '" + this.argv[this.optind] + "' is ambiguous\n");
                }
                this.nextchar = "";
                this.optopt = 0;
                ++this.optind;
                return 63;
            }
            if (longOpt == null) {
                this.longopt_handled = false;
                return 0;
            }
            ++this.optind;
            if (n != this.nextchar.length()) {
                if (longOpt.has_arg != 0) {
                    this.optarg = this.nextchar.substring(n).length() > 1 ? this.nextchar.substring(n + 1) : "";
                    break block21;
                } else {
                    if (this.opterr) {
                        if (this.argv[this.optind - 1].startsWith("--")) {
                            System.err.print(String.valueOf(this.progname) + ": option '--" + longOpt.name + "' doesn't allow an" + " argument\n");
                        } else {
                            System.err.print(String.valueOf(this.progname) + ": option '" + this.argv[this.optind - 1].charAt(0) + longOpt.name + "' doesn't allow" + " an argument\n");
                        }
                    }
                    this.nextchar = "";
                    this.optopt = longOpt.val;
                    return 63;
                }
            }
            if (longOpt.has_arg == 1) {
                if (this.optind < this.argv.length) {
                    this.optarg = this.argv[this.optind];
                    ++this.optind;
                } else {
                    if (this.opterr) {
                        System.err.print(String.valueOf(this.progname) + ": option '" + this.argv[this.optind - 1] + "' requires an argument\n");
                    }
                    this.nextchar = "";
                    this.optopt = longOpt.val;
                    if (this.optstring.charAt(0) == ':') {
                        return 58;
                    }
                    return 63;
                }
            }
        }
        this.nextchar = "";
        if (longOpt.flag != null) {
            longOpt.flag.setLength(0);
            longOpt.flag.append(longOpt.val);
            return 0;
        }
        return longOpt.val;
    }

    public int getopt() {
        int n;
        this.optarg = null;
        if (this.nextchar == null || this.nextchar.equals("")) {
            if (this.last_nonopt > this.optind) {
                this.last_nonopt = this.optind;
            }
            if (this.first_nonopt > this.optind) {
                this.first_nonopt = this.optind;
            }
            if (this.ordering == 2) {
                if (this.first_nonopt != this.last_nonopt && this.last_nonopt != this.optind) {
                    this.exchange(this.argv);
                } else if (this.last_nonopt != this.optind) {
                    this.first_nonopt = this.optind;
                }
                while (this.optind < this.argv.length && (this.argv[this.optind].charAt(0) != '-' || this.argv[this.optind].equals("-"))) {
                    ++this.optind;
                }
                this.last_nonopt = this.optind;
            }
            if (this.optind != this.argv.length && this.argv[this.optind].equals("--")) {
                ++this.optind;
                if (this.first_nonopt != this.last_nonopt && this.last_nonopt != this.optind) {
                    this.exchange(this.argv);
                } else if (this.first_nonopt == this.last_nonopt) {
                    this.first_nonopt = this.optind;
                }
                this.last_nonopt = this.argv.length;
                this.optind = this.argv.length;
            }
            if (this.optind == this.argv.length) {
                if (this.first_nonopt != this.last_nonopt) {
                    this.optind = this.first_nonopt;
                }
                return -1;
            }
            if (this.argv[this.optind].charAt(0) != '-' || this.argv[this.optind].equals("-")) {
                if (this.ordering == 1) {
                    return -1;
                }
                this.optarg = this.argv[this.optind++];
                return 1;
            }
            this.nextchar = this.argv[this.optind].startsWith("--") ? this.argv[this.optind].substring(2) : this.argv[this.optind].substring(1);
        }
        if (this.long_options != null && (this.argv[this.optind].startsWith("--") || this.long_only && (this.argv[this.optind].length() > 2 || this.optstring.indexOf(this.argv[this.optind].charAt(1)) == -1))) {
            n = this.checkLongOption();
            if (this.longopt_handled) {
                return n;
            }
            if (!this.long_only || this.argv[this.optind].startsWith("--") || this.optstring.indexOf(this.nextchar.charAt(0)) == -1) {
                if (this.opterr) {
                    if (this.argv[this.optind].startsWith("--")) {
                        System.err.print(String.valueOf(this.progname) + ": unrecognized option '--" + this.nextchar + "'\n");
                    } else {
                        System.err.print(String.valueOf(this.progname) + ": unrecognized option '" + this.argv[this.optind].charAt(0) + this.nextchar + "'\n");
                    }
                }
                this.nextchar = "";
                ++this.optind;
                this.optopt = 0;
                return 63;
            }
        }
        n = this.nextchar.charAt(0);
        this.nextchar = this.nextchar.length() > 1 ? this.nextchar.substring(1) : "";
        String string = null;
        if (this.optstring.indexOf(n) != -1) {
            string = this.optstring.substring(this.optstring.indexOf(n));
        }
        if (this.nextchar.equals("")) {
            ++this.optind;
        }
        if (string == null || n == 58) {
            if (this.opterr) {
                if (this.posixly_correct) {
                    System.err.print(String.valueOf(this.progname) + ": illegal option -- " + (char)n + "\n");
                } else {
                    System.err.print(String.valueOf(this.progname) + ": invalid option -- " + (char)n + "\n");
                }
            }
            this.optopt = n;
            return 63;
        }
        if (string.charAt(0) == 'W' && string.length() > 1 && string.charAt(1) == ';') {
            if (!this.nextchar.equals("")) {
                this.optarg = this.nextchar;
            } else {
                if (this.optind == this.argv.length) {
                    if (this.opterr) {
                        System.err.print(String.valueOf(this.progname) + ": option requires an argument -- " + (char)n + "\n");
                    }
                    this.optopt = n;
                    if (this.optstring.charAt(0) == ':') {
                        return 58;
                    }
                    return 63;
                }
                this.nextchar = this.argv[this.optind];
                this.optarg = this.argv[this.optind];
            }
            n = this.checkLongOption();
            if (this.longopt_handled) {
                return n;
            }
            this.nextchar = null;
            ++this.optind;
            return 87;
        }
        if (string.length() > 1 && string.charAt(1) == ':') {
            if (string.length() > 2 && string.charAt(2) == ':') {
                if (!this.nextchar.equals("")) {
                    this.optarg = this.nextchar;
                    ++this.optind;
                } else {
                    this.optarg = null;
                }
                this.nextchar = null;
            } else {
                if (!this.nextchar.equals("")) {
                    this.optarg = this.nextchar;
                    ++this.optind;
                } else {
                    if (this.optind == this.argv.length) {
                        if (this.opterr) {
                            System.err.print(String.valueOf(this.progname) + ": option requires an " + "argument -- " + (char)n + "\n");
                        }
                        this.optopt = n;
                        if (this.optstring.charAt(0) == ':') {
                            return 58;
                        }
                        return 63;
                    }
                    this.optarg = this.argv[this.optind];
                    ++this.optind;
                }
                this.nextchar = null;
            }
        }
        return n;
    }

    public static void main(String[] stringArray) {
        int n;
        LongOpt[] longOptArray = new LongOpt[3];
        StringBuffer stringBuffer = new StringBuffer();
        longOptArray[0] = new LongOpt("help", 0, null, 104);
        longOptArray[1] = new LongOpt("outputdir", 1, stringBuffer, 111);
        longOptArray[2] = new LongOpt("maximum", 2, null, 2);
        Getopt getopt = new Getopt("testprog", stringArray, "-:bc::d:hW;", longOptArray);
        getopt.setOpterr(false);
        while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 0: {
                    String string = getopt.getOptarg();
                    System.out.print("Got long option with value '" + (char)new Integer(stringBuffer.toString()).intValue() + "' with argument " + (string != null ? string : "null") + "\n");
                    break;
                }
                case 1: {
                    System.out.print("I see you have return in order set and that a non-option argv element was just found with the value '" + getopt.getOptarg() + "'\n");
                    break;
                }
                case 2: {
                    String string = getopt.getOptarg();
                    System.out.print("I know this, but pretend I didn't\n");
                    System.out.print("We picked option " + longOptArray[getopt.getLongind()].getName() + " with value " + (string != null ? string : "null") + "\n");
                    break;
                }
                case 98: {
                    System.out.print("You picked plain old option " + (char)n + "\n");
                    break;
                }
                case 99: 
                case 100: {
                    String string = getopt.getOptarg();
                    System.out.print("You picked option '" + (char)n + "' with argument " + (string != null ? string : "null") + "\n");
                    break;
                }
                case 104: {
                    System.out.print("I see you asked for help\n");
                    break;
                }
                case 87: {
                    System.out.print("Hmmm. You tried a -W with an incorrect long option name\n");
                    break;
                }
                case 58: {
                    System.out.print("Doh! You need an argument for option " + (char)getopt.getOptopt() + "\n");
                    break;
                }
                case 63: {
                    System.out.print("The option '" + (char)getopt.getOptopt() + "' is not valid\n");
                    break;
                }
                default: {
                    System.out.print("getopt() returned " + n + "\n");
                }
            }
        }
        int n2 = getopt.getOptind();
        while (n2 < stringArray.length) {
            System.out.print("Non option argv element: " + stringArray[n2] + "\n");
            ++n2;
        }
    }
}

