/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharUnit;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import gnu.regexp.RESyntax;
import gnu.regexp.REToken;
import gnu.regexp.RETokenAny;
import gnu.regexp.RETokenBackRef;
import gnu.regexp.RETokenChar;
import gnu.regexp.RETokenEnd;
import gnu.regexp.RETokenOneOf;
import gnu.regexp.RETokenPOSIX;
import gnu.regexp.RETokenRange;
import gnu.regexp.RETokenRepeated;
import gnu.regexp.RETokenStart;
import gnu.regexp.RETokenStingifiable;
import gnu.regexp.RETokenSubMarker;
import java.io.Serializable;
import java.util.Vector;

public class RE
extends REToken
implements Serializable {
    private static final String version = "1.00";
    private REToken firstToken;
    private REToken lastToken;
    private Vector branches;
    private int numSubs;
    public static final int REG_ICASE = 2;
    public static final int REG_DOT_NEWLINE = 4;
    public static final int REG_MULTILINE = 8;
    public static final int REG_NOTBOL = 16;
    public static final int REG_NOTEOL = 32;
    public static final int REG_ANCHORINDEX = 64;

    public RE(String string) throws REException {
        this(string.toCharArray(), 0, RESyntax.RE_SYNTAX_PERL5);
    }

    public RE(String string, int n) throws REException {
        this(string.toCharArray(), n, RESyntax.RE_SYNTAX_PERL5);
    }

    public RE(String string, int n, RESyntax rESyntax) throws REException {
        this(string.toCharArray(), n, rESyntax);
    }

    public RE(char[] cArray) throws REException {
        this(cArray, 0);
    }

    public RE(char[] cArray, int n) throws REException {
        this(cArray, n, RESyntax.RE_SYNTAX_PERL5);
    }

    private RE(REToken rEToken, REToken rEToken2) {
        this.firstToken = rEToken;
        this.lastToken = rEToken2;
    }

    private static int getCharUnit(char[] cArray, int n, CharUnit charUnit) throws REException {
        charUnit.ch = cArray[n++];
        charUnit.bk = charUnit.ch == '\\';
        if (charUnit.bk) {
            if (n < cArray.length) {
                charUnit.ch = cArray[n++];
            } else {
                throw new REException("\\ at end of pattern.", 10, n);
            }
        }
        return n;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RE(char[] cArray, int n, RESyntax rESyntax) throws REException {
        int n2;
        void var8_9;
        this.lastToken = null;
        this.firstToken = null;
        this.numSubs = 0;
        boolean bl = (n & 2) > 0;
        int n3 = 0;
        CharUnit charUnit = new CharUnit();
        IntPair intPair = new IntPair();
        Object var8_8 = null;
        while (n3 < cArray.length) {
            n3 = RE.getCharUnit(cArray, n3, charUnit);
            if ((charUnit.ch == '|' && rESyntax.get(14) ^ charUnit.bk || rESyntax.get(10) && charUnit.ch == '\n' && !charUnit.bk) && !rESyntax.get(9)) {
                if (this.branches == null) {
                    this.branches = new Vector();
                }
                this.addToken((REToken)var8_9);
                this.branches.addElement(new RE(this.firstToken, this.lastToken));
                Object var8_10 = null;
                this.lastToken = null;
                this.firstToken = null;
                continue;
            }
            if (charUnit.ch == '{' && rESyntax.get(8) && (rESyntax.get(11) || charUnit.bk)) {
                if (var8_9 == null) {
                    throw new REException("{ without preceding token", 3, n3);
                }
                n3 = RE.getMinMax(cArray, n3, intPair, rESyntax);
                RETokenRepeated rETokenRepeated = new RETokenRepeated((REToken)var8_9, intPair.first, intPair.second);
                continue;
            }
            if (charUnit.ch == '[' && !charUnit.bk) {
                Vector<REToken> vector = new Vector<REToken>();
                if (n3 == cArray.length) {
                    throw new REException("unmatched [", 4, n3);
                }
                char c = cArray[n3];
                int n4 = n2 = c != '^' ? 0 : 1;
                if (n2 != 0) {
                    c = cArray[++n3];
                }
                char c2 = '\u0000';
                if (c == ']' || c == '-') {
                    c2 = c;
                    ++n3;
                }
                while ((c = cArray[n3]) != ']') {
                    if (c == '-') {
                        if (c2 == '\u0000') throw new REException("- indeterminate", 5, n3);
                        c = cArray[++n3];
                        vector.addElement(new RETokenRange(c2, c, bl));
                        c2 = '\u0000';
                    } else if (c == '\\' && rESyntax.get(0)) {
                        c = cArray[++n3];
                        if (c2 != '\u0000') {
                            vector.addElement(new RETokenChar(c2, bl));
                        }
                        c2 = c;
                    } else if (c == '[') {
                        if (rESyntax.get(2) && cArray[n3 + 1] == ':') {
                            StringBuffer stringBuffer = new StringBuffer();
                            n3 = RE.getPosixSet(cArray, n3 + 2, stringBuffer);
                            String string = stringBuffer.toString();
                            if (string.equals("alnum")) {
                                vector.addElement(new RETokenPOSIX(0, bl, false));
                            } else if (string.equals("alpha")) {
                                vector.addElement(new RETokenPOSIX(1, bl, false));
                            } else if (string.equals("blank")) {
                                vector.addElement(new RETokenPOSIX(2, bl, false));
                            } else if (string.equals("cntrl")) {
                                vector.addElement(new RETokenPOSIX(3, bl, false));
                            } else if (string.equals("digit")) {
                                vector.addElement(new RETokenPOSIX(4, bl, false));
                            } else if (string.equals("graph")) {
                                vector.addElement(new RETokenPOSIX(5, bl, false));
                            } else if (string.equals("lower")) {
                                vector.addElement(new RETokenPOSIX(6, bl, false));
                            } else if (string.equals("print")) {
                                vector.addElement(new RETokenPOSIX(7, bl, false));
                            } else if (string.equals("punct")) {
                                vector.addElement(new RETokenPOSIX(8, bl, false));
                            } else if (string.equals("space")) {
                                vector.addElement(new RETokenPOSIX(9, bl, false));
                            } else if (string.equals("upper")) {
                                vector.addElement(new RETokenPOSIX(10, bl, false));
                            } else if (string.equals("xdigit")) {
                                vector.addElement(new RETokenPOSIX(11, bl, false));
                            }
                        }
                    } else {
                        if (c2 != '\u0000') {
                            vector.addElement(new RETokenChar(c2, bl));
                        }
                        c2 = c;
                    }
                    ++n3;
                }
                ++n3;
                if (c2 != '\u0000') {
                    vector.addElement(new RETokenChar(c2, bl));
                }
                this.addToken((REToken)var8_9);
                vector.trimToSize();
                RETokenOneOf rETokenOneOf = new RETokenOneOf(vector, n2 != 0);
                continue;
            }
            if (charUnit.ch == '(' && rESyntax.get(12) ^ charUnit.bk) {
                int n5 = n3;
                n2 = n3;
                while (!((n2 = RE.getCharUnit(cArray, n5, charUnit)) <= 0 || charUnit.ch == ')' && rESyntax.get(12) ^ charUnit.bk)) {
                    n5 = n2;
                    if (n5 < cArray.length) continue;
                    throw new REException("no end of subexpression", 8, n3 - 1);
                }
                this.addToken((REToken)var8_9);
                Object var8_13 = null;
                ++this.numSubs;
                RE rE = new RE(String.valueOf(cArray, n3, n5 - n3).toCharArray(), n, rESyntax);
                n3 = n2;
                if (n3 == cArray.length) {
                    this.addToken(new RETokenSubMarker(rE, this.numSubs, 1, 1));
                    continue;
                }
                n2 = RE.getCharUnit(cArray, n3, charUnit);
                if (charUnit.ch == '{' && rESyntax.get(8) && rESyntax.get(11) ^ charUnit.bk) {
                    n3 = RE.getMinMax(cArray, n2, intPair, rESyntax);
                    RETokenSubMarker rETokenSubMarker = new RETokenSubMarker(rE, this.numSubs, intPair.first, intPair.second);
                    continue;
                }
                if (charUnit.ch == '*' && !charUnit.bk) {
                    RETokenSubMarker rETokenSubMarker = new RETokenSubMarker(rE, this.numSubs, 0, Integer.MAX_VALUE);
                    n3 = n2;
                    continue;
                }
                if (charUnit.ch == '+' && !rESyntax.get(9) && !rESyntax.get(1) ^ charUnit.bk) {
                    RETokenSubMarker rETokenSubMarker = new RETokenSubMarker(rE, this.numSubs, 1, Integer.MAX_VALUE);
                    n3 = n2;
                    continue;
                }
                if (charUnit.ch == '?' && !rESyntax.get(9) && !rESyntax.get(1) ^ charUnit.bk) {
                    RETokenSubMarker rETokenSubMarker = new RETokenSubMarker(rE, this.numSubs, 0, 1);
                    n3 = n2;
                    continue;
                }
                this.addToken(new RETokenSubMarker(rE, this.numSubs, 1, 1));
                continue;
            }
            if (charUnit.ch == '^' && !charUnit.bk) {
                this.addToken((REToken)var8_9);
                Object var8_18 = null;
                this.addToken(new RETokenStart((n & 8) > 0));
                continue;
            }
            if (charUnit.ch == '$' && !charUnit.bk) {
                this.addToken((REToken)var8_9);
                Object var8_19 = null;
                this.addToken(new RETokenEnd((n & 8) > 0));
                continue;
            }
            if (charUnit.ch == '.' && !charUnit.bk) {
                this.addToken((REToken)var8_9);
                RETokenAny rETokenAny = new RETokenAny(rESyntax.get(6) || (n & 4) > 0, rESyntax.get(7));
                continue;
            }
            if (charUnit.ch == '*' && !charUnit.bk) {
                if (var8_9 == null) {
                    throw new REException("* without preceding token", 1, n3);
                }
                RETokenRepeated rETokenRepeated = new RETokenRepeated((REToken)var8_9, 0, Integer.MAX_VALUE);
                continue;
            }
            if (charUnit.ch == '+' && !rESyntax.get(9) && !rESyntax.get(1) ^ charUnit.bk) {
                if (var8_9 == null) {
                    throw new REException("+ without preceding token", 1, n3);
                }
                RETokenRepeated rETokenRepeated = new RETokenRepeated((REToken)var8_9, 1, Integer.MAX_VALUE);
                continue;
            }
            if (charUnit.ch == '?' && !rESyntax.get(9) && !rESyntax.get(1) ^ charUnit.bk) {
                if (var8_9 == null) {
                    throw new REException("? without preceding token", 1, n3);
                }
                if (var8_9 instanceof RETokenStingifiable) {
                    ((RETokenStingifiable)var8_9).makeStingy();
                    continue;
                }
                RETokenRepeated rETokenRepeated = new RETokenRepeated((REToken)var8_9, 0, 1);
                continue;
            }
            if (charUnit.bk && Character.isDigit(charUnit.ch) && !rESyntax.get(13)) {
                this.addToken((REToken)var8_9);
                RETokenBackRef rETokenBackRef = new RETokenBackRef(Character.digit(charUnit.ch, 10), bl);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'A' && rESyntax.get(22)) {
                this.addToken((REToken)var8_9);
                RETokenStart rETokenStart = new RETokenStart(false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'd' && rESyntax.get(19)) {
                this.addToken((REToken)var8_9);
                RETokenPOSIX rETokenPOSIX = new RETokenPOSIX(4, bl, false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'D' && rESyntax.get(19)) {
                this.addToken((REToken)var8_9);
                RETokenPOSIX rETokenPOSIX = new RETokenPOSIX(4, bl, true);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'n') {
                this.addToken((REToken)var8_9);
                RETokenChar rETokenChar = new RETokenChar('\n', false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'r') {
                this.addToken((REToken)var8_9);
                RETokenChar rETokenChar = new RETokenChar('\r', false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 's' && rESyntax.get(19)) {
                this.addToken((REToken)var8_9);
                RETokenPOSIX rETokenPOSIX = new RETokenPOSIX(9, bl, false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'S' && rESyntax.get(19)) {
                this.addToken((REToken)var8_9);
                RETokenPOSIX rETokenPOSIX = new RETokenPOSIX(9, bl, true);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 't') {
                this.addToken((REToken)var8_9);
                RETokenChar rETokenChar = new RETokenChar('\t', false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'w' && rESyntax.get(19)) {
                this.addToken((REToken)var8_9);
                RETokenPOSIX rETokenPOSIX = new RETokenPOSIX(0, bl, false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'W' && rESyntax.get(19)) {
                this.addToken((REToken)var8_9);
                RETokenPOSIX rETokenPOSIX = new RETokenPOSIX(0, bl, true);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'Z' && rESyntax.get(22)) {
                this.addToken((REToken)var8_9);
                RETokenEnd rETokenEnd = new RETokenEnd(false);
                continue;
            }
            this.addToken((REToken)var8_9);
            RETokenChar rETokenChar = new RETokenChar(charUnit.ch, bl);
        }
        this.addToken((REToken)var8_9);
        if (this.branches == null) return;
        this.branches.addElement(new RE(this.firstToken, this.lastToken));
        Object var8_37 = null;
        this.lastToken = null;
        this.firstToken = null;
        this.branches.trimToSize();
        n2 = 0;
        while (n2 < this.branches.size()) {
            int n6 = ((RE)this.branches.elementAt(n2)).getNumSubs();
            if (n6 > this.numSubs) {
                this.numSubs = n6;
            }
            ++n2;
        }
    }

    public boolean isMatch(String string) {
        return this.isMatch(string, 0, 0);
    }

    public boolean isMatch(String string, int n) {
        return this.isMatch(string, n, 0);
    }

    public boolean isMatch(String string, int n, int n2) {
        if (this.branches != null) {
            int n3 = 0;
            while (n3 < this.branches.size()) {
                if (((RE)this.branches.elementAt(n3)).isMatch(string, n, n2)) {
                    return true;
                }
                ++n3;
            }
            return false;
        }
        return this.firstToken.match(string, n, n2, new REMatch(string, this.numSubs, n)) == string.length();
    }

    public int getNumSubs() {
        return this.numSubs;
    }

    public REMatch[] getAllMatches(String string) {
        return this.getAllMatches(string, 0, 0);
    }

    public REMatch[] getAllMatches(String string, int n) {
        return this.getAllMatches(string, n, 0);
    }

    public REMatch[] getAllMatches(String string, int n, int n2) {
        Vector<REMatch> vector = new Vector<REMatch>();
        REMatch rEMatch = null;
        while ((rEMatch = this.getMatch(string, n, n2)) != null) {
            vector.addElement(rEMatch);
            n = rEMatch.start[0] + 1;
        }
        Object[] objectArray = new REMatch[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    int match(String string, int n, int n2, REMatch rEMatch) {
        if (this.branches != null) {
            int n3 = 0;
            while (n3 < this.branches.size()) {
                int n4 = ((REToken)this.branches.elementAt(n3)).match(string, n, n2, rEMatch);
                if (n4 != -1) {
                    return n4;
                }
                ++n3;
            }
            return -1;
        }
        return this.firstToken.match(string, n, n2, rEMatch);
    }

    public REMatch getMatch(String string) {
        return this.getMatch(string, 0, 0);
    }

    public REMatch getMatch(String string, int n) {
        return this.getMatch(string, n, 0);
    }

    public REMatch getMatch(String string, int n, int n2) {
        REMatch rEMatch = new REMatch(string, this.numSubs, n);
        while (n <= string.length()) {
            rEMatch.end[0] = this.match(string, n, n2, rEMatch);
            if (rEMatch.end[0] != -1) {
                rEMatch.start[0] = n;
                return rEMatch;
            }
            rEMatch.clear();
            ++n;
        }
        return null;
    }

    public String substitute(String string, String string2) {
        return this.substitute(string, string2, 0, 0);
    }

    public String substitute(String string, String string2, int n) {
        return this.substitute(string, string2, n, 0);
    }

    public String substitute(String string, String string2, int n, int n2) {
        REMatch rEMatch = this.getMatch(string, n, n2);
        if (rEMatch == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.substring(0, rEMatch.start[0]));
        stringBuffer.append(string2);
        stringBuffer.append(string.substring(rEMatch.end[0]));
        return new String(stringBuffer);
    }

    public String substituteAll(String string, String string2) {
        return this.substituteAll(string, string2, 0, 0);
    }

    public String substituteAll(String string, String string2, int n) {
        return this.substituteAll(string, string2, n, 0);
    }

    public String substituteAll(String string, String string2, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n > 0) {
            stringBuffer.append(string.substring(0, n));
        }
        REMatch rEMatch = null;
        while ((rEMatch = this.getMatch(string, n, 0)) != null) {
            stringBuffer.append(string.substring(n, rEMatch.start[0]));
            stringBuffer.append(string2);
            n = rEMatch.end[0];
        }
        stringBuffer.append(string.substring(n));
        return new String(stringBuffer);
    }

    private void addToken(REToken rEToken) {
        if (rEToken == null) {
            return;
        }
        if (this.firstToken == null) {
            this.lastToken = this.firstToken = rEToken;
            return;
        }
        if (this.lastToken.chain(rEToken)) {
            this.lastToken = rEToken;
        }
    }

    void addLoop(REToken rEToken) {
        if (this.branches != null) {
            int n = 0;
            while (n < this.branches.size()) {
                ((RE)this.branches.elementAt(n)).addLoop(rEToken);
                ++n;
            }
            return;
        }
        if (this.firstToken == null) {
            this.lastToken = this.firstToken = rEToken;
            return;
        }
        if (this.lastToken.chain(rEToken)) {
            this.lastToken = rEToken;
        }
    }

    public static String version() {
        return version;
    }

    private static int getPosixSet(char[] cArray, int n, StringBuffer stringBuffer) {
        int n2 = n;
        while (n2 < cArray.length - 1) {
            if (cArray[n2] == ':' && cArray[n2 + 1] == ']') {
                return n2 + 1;
            }
            stringBuffer.append(cArray[n2]);
            ++n2;
        }
        return n;
    }

    private static int getMinMax(char[] cArray, int n, IntPair intPair, RESyntax rESyntax) throws REException {
        if (n == cArray.length) {
            throw new REException("no matching brace", 3, n);
        }
        int n2 = 0;
        CharUnit charUnit = new CharUnit();
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = RE.getCharUnit(cArray, n, charUnit)) != cArray.length && Character.isDigit(charUnit.ch)) {
            stringBuffer.append(charUnit.ch);
        }
        if (stringBuffer.length() == 0) {
            throw new REException("bad brace construct", 3, n);
        }
        int n3 = Integer.parseInt(stringBuffer.toString());
        if (charUnit.ch == '}' && rESyntax.get(11) ^ charUnit.bk) {
            n2 = n3;
        } else if (charUnit.ch == ',' && !charUnit.bk) {
            stringBuffer = new StringBuffer();
            while ((n = RE.getCharUnit(cArray, n, charUnit)) != cArray.length && Character.isDigit(charUnit.ch)) {
                stringBuffer.append(charUnit.ch);
            }
            if (charUnit.ch != '}' || !(rESyntax.get(11) ^ charUnit.bk)) {
                throw new REException("expected end of interval", 3, n);
            }
            n2 = stringBuffer.length() == 0 ? Integer.MAX_VALUE : Integer.parseInt(stringBuffer.toString());
        } else {
            throw new REException("invalid character in brace expression", 3, n);
        }
        intPair.first = n3;
        intPair.second = n2;
        return n;
    }

    private class IntPair
    implements Serializable {
        public int first;
        public int second;

        public IntPair() {
            RE.this = RE.this;
        }
    }
}

