/*
 * Decompiled with CFR 0.152.
 */
package org.doit.io;

import java.io.IOException;
import org.doit.io.InputObjectStream;

public class OutputObjectStream {
    protected InputObjectStream in;
    protected boolean connected = false;

    public OutputObjectStream(InputObjectStream inputObjectStream) throws IOException {
        this.connect(inputObjectStream);
    }

    public OutputObjectStream() {
    }

    public void connect(InputObjectStream inputObjectStream) throws IOException {
        if (this.connected) {
            throw new IOException("Output side already connected");
        }
        if (inputObjectStream.connected) {
            throw new IOException("Input side already connected");
        }
        this.in = inputObjectStream;
        inputObjectStream.closed = false;
        inputObjectStream.objects.removeAllElements();
        this.connected = true;
    }

    public void write(Object object) throws IOException {
        this.in.append(object);
    }

    public synchronized void flush() throws IOException {
        if (this.in != null) {
            InputObjectStream inputObjectStream = this.in;
            synchronized (inputObjectStream) {
                this.in.notify();
                return;
            }
        }
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.done();
        }
    }
}

