/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.doit.muffin.Handler;
import org.doit.muffin.Main;
import org.doit.muffin.Monitor;
import org.doit.muffin.Reply;
import org.doit.muffin.Request;

class CanvasMonitor
extends Canvas
implements Monitor {
    Vector handlers = new Vector(100);
    Font font = Main.options.getFont("muffin.smallfont");
    FontMetrics fontMetrics = this.getFontMetrics(this.font);
    boolean suspended = false;
    Hashtable colorTable;

    CanvasMonitor() {
        this.setFont(this.font);
        this.colorTable = new Hashtable();
        this.colorTable.put("text/html", Color.cyan);
        this.colorTable.put("text/plain", Color.cyan);
        this.colorTable.put("image/gif", Color.green);
        this.colorTable.put("image/jpeg", Color.green);
        this.colorTable.put("image/jpg", Color.green);
        this.colorTable.put("image/tiff", Color.green);
        this.colorTable.put("image/x-png", Color.green);
        this.colorTable.put("audio/basic", Color.orange);
        this.colorTable.put("audio/x-wav", Color.orange);
        this.colorTable.put("audio/x-aiff", Color.orange);
        this.colorTable.put("audio/x-realaudio", Color.orange);
        this.colorTable.put("secure", Color.yellow);
        this.colorTable.put("default", Color.white);
    }

    public void register(Handler handler) {
        this.handlers.addElement(handler);
        this.repaint();
    }

    public void unregister(Handler handler) {
        this.handlers.removeElement(handler);
        this.repaint();
    }

    public void update(Handler handler) {
        this.repaint();
    }

    public void suspend() {
        this.suspended = true;
        this.repaint();
    }

    public void resume() {
        this.suspended = false;
        this.repaint();
    }

    public Enumeration enumerate() {
        return this.handlers.elements();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(200, 150);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        Image image = this.createImage(dimension.width, dimension.height);
        this.draw(image.getGraphics());
        graphics.drawImage(image, 0, 0, this);
    }

    void draw(Graphics graphics) {
        Insets insets = new Insets(5, 5, 5, 5);
        Dimension dimension = this.getSize();
        if (this.suspended) {
            Color color = Main.options.getColor("muffin.bg");
            color = color.darker();
            graphics.setColor(color);
            graphics.fill3DRect(2, 2, dimension.width - 4, dimension.height - 4, false);
        } else {
            graphics.setColor(Main.options.getColor("muffin.bg"));
            graphics.fill3DRect(2, 2, dimension.width - 4, dimension.height - 4, true);
        }
        int n = insets.top;
        Enumeration enumeration = this.handlers.elements();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2;
            Object e = enumeration.nextElement();
            Handler handler = (Handler)e;
            Reply reply = handler.reply;
            Request request = handler.request;
            int n2 = this.fontMetrics.getHeight();
            int n3 = handler.getCurrentBytes();
            int n4 = handler.getTotalBytes();
            int n5 = 0;
            int n6 = dimension.width - insets.left - insets.right;
            String string3 = null;
            StringBuffer stringBuffer = new StringBuffer();
            if (reply != null) {
                string3 = reply.getContentType();
                if (string3 != null) {
                    stringBuffer.append(string3);
                    stringBuffer.append(" ");
                }
                if (n4 > 0) {
                    double d = (double)n3 / (double)n4;
                    if (d > 1.0) {
                        d = 1.0;
                    }
                    n5 = (int)(d * (double)n6);
                    stringBuffer.append((int)(d * 100.0));
                    stringBuffer.append("% of ");
                    if (n4 >= 1024) {
                        stringBuffer.append(n4 / 1024);
                        stringBuffer.append("k");
                    } else {
                        stringBuffer.append(n4);
                        stringBuffer.append(" bytes");
                    }
                } else if (n3 >= 1024) {
                    stringBuffer.append(n3 / 1024);
                    stringBuffer.append("k");
                } else {
                    stringBuffer.append(n3);
                    stringBuffer.append(" bytes");
                }
                if (request.getCommand().equals("CONNECT")) {
                    stringBuffer.append(" - ");
                    stringBuffer.append(request.getHost());
                } else {
                    String string4 = request.getURL();
                    string2 = request.getPath();
                    string = request.getDocument();
                    if (this.fontMetrics.stringWidth(String.valueOf(stringBuffer.toString()) + string4 + " - ") < n6 - 5) {
                        stringBuffer.append(" - ");
                        stringBuffer.append(string4);
                    } else if (this.fontMetrics.stringWidth(String.valueOf(stringBuffer.toString()) + string2 + " - ") < n6 - 5) {
                        stringBuffer.append(" - ");
                        stringBuffer.append(string2);
                    } else if (this.fontMetrics.stringWidth(String.valueOf(stringBuffer.toString()) + string + " - ") < n6 - 5) {
                        stringBuffer.append(" - ");
                        stringBuffer.append(string);
                    }
                }
            } else {
                if (request == null) continue;
                stringBuffer.append("Contacting ");
                String string5 = request.getURL();
                if (request.getCommand().equals("CONNECT")) {
                    stringBuffer.append(request.getHost());
                    stringBuffer.append(" ");
                    stringBuffer.append(request.getPort());
                } else if (this.fontMetrics.stringWidth(String.valueOf(stringBuffer.toString()) + string5) < n6 - 5) {
                    stringBuffer.append(string5);
                } else {
                    stringBuffer.append(request.getHost());
                    string2 = request.getPath();
                    string = request.getDocument();
                    if (this.fontMetrics.stringWidth(String.valueOf(stringBuffer.toString()) + string2) < n6 - 5) {
                        stringBuffer.append(string2);
                    } else if (this.fontMetrics.stringWidth(String.valueOf(stringBuffer.toString()) + string + "...") < n6 - 5) {
                        stringBuffer.append("...");
                        stringBuffer.append(string);
                    }
                }
                if (this.fontMetrics.stringWidth(String.valueOf(stringBuffer.toString()) + " ...") < n6 - 5) {
                    stringBuffer.append(" ...");
                }
            }
            boolean bl = request.getCommand().equals("CONNECT");
            graphics.setColor(Main.options.getColor("muffin.bg"));
            graphics.fill3DRect(insets.left, n, n6, n2, true);
            if (bl) {
                graphics.setColor((Color)this.colorTable.get("secure"));
            } else if (string3 == null || !this.colorTable.containsKey(string3)) {
                graphics.setColor((Color)this.colorTable.get("default"));
            } else {
                graphics.setColor((Color)this.colorTable.get(string3));
            }
            if (bl) {
                graphics.fillRect(insets.left + 1, n + 1, n6 - 2, n2 - 2);
            } else {
                graphics.fillRect(insets.left + 1, n + 1, n5 - 2, n2 - 2);
            }
            graphics.setColor(Color.black);
            graphics.drawString(stringBuffer.toString(), insets.left + 5, n + n2 - this.fontMetrics.getMaxDescent());
            n += n2 + 5;
        }
    }
}

