/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.doit.io.ByteArray;
import org.doit.io.HtmlObjectStream;
import org.doit.io.InputObjectStream;
import org.doit.io.OutputObjectStream;
import org.doit.io.SourceObjectStream;
import org.doit.muffin.Client;
import org.doit.muffin.ContentFilter;
import org.doit.muffin.Copy;
import org.doit.muffin.Filter;
import org.doit.muffin.FilterException;
import org.doit.muffin.FilterManager;
import org.doit.muffin.Http;
import org.doit.muffin.HttpConnection;
import org.doit.muffin.HttpError;
import org.doit.muffin.HttpFilter;
import org.doit.muffin.HttpRelay;
import org.doit.muffin.Httpd;
import org.doit.muffin.Https;
import org.doit.muffin.Monitor;
import org.doit.muffin.Options;
import org.doit.muffin.RedirectFilter;
import org.doit.muffin.Reply;
import org.doit.muffin.ReplyFilter;
import org.doit.muffin.Request;
import org.doit.muffin.RequestFilter;
import org.doit.muffin.RetryRequestException;

class Handler
extends Thread {
    static final boolean DEBUG = false;
    ThreadGroup filterGroup;
    Monitor monitor;
    FilterManager manager;
    Options options;
    Client client;
    Socket socket;
    Request request;
    Reply reply;
    HttpRelay http;
    int currentLength = -1;
    int contentLength = -1;
    Filter[] filterList;
    long idle;
    double bytesPerSecond;

    Handler(ThreadGroup threadGroup, Runnable runnable, Monitor monitor, FilterManager filterManager, Options options) {
        super(threadGroup, runnable);
        this.monitor = monitor;
        this.manager = filterManager;
        this.options = options;
    }

    void doit(Socket socket) {
        this.socket = socket;
        this.start();
    }

    synchronized void close() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        if (this.http != null) {
            this.http.close();
            this.http = null;
        }
    }

    void flush() {
        if (this.client != null) {
            try {
                this.client.getOutputStream().flush();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    void kill() {
        this.monitor.unregister(this);
        this.stop();
    }

    public void run() {
        Thread.currentThread().setName("Handler (" + this.socket.getInetAddress() + ")");
        this.filterGroup = new ThreadGroup("Filters (" + this.socket.getInetAddress() + ")");
        try {
            this.client = new Client(this.socket);
        }
        catch (Exception exception) {
            return;
        }
        boolean bl = false;
        this.monitor.register(this);
        do {
            this.request = null;
            this.reply = null;
            this.filterList = null;
            this.idle = System.currentTimeMillis();
            this.monitor.update(this);
            try {
                this.request = this.client.read();
            }
            catch (IOException iOException) {
                break;
            }
            this.idle = 0L;
            this.monitor.update(this);
            try {
                bl = this.processRequest();
            }
            catch (Exception exception) {
                if (this.client != null && this.request != null) {
                    this.error(this.client.getOutputStream(), exception, this.request);
                }
                exception.printStackTrace();
                break;
            }
        } while (bl);
        this.monitor.unregister(this);
        this.close();
    }

    boolean processRequest() throws Exception {
        boolean bl = false;
        while (this.reply == null) {
            Object object;
            Object object2;
            boolean bl2 = false;
            this.manager.checkAutoConfig(this.request.getURL());
            this.filterList = this.manager.createFilters();
            if (this.request.getCommand().equals("CONNECT")) {
                bl2 = true;
            } else if (this.request.getURL().startsWith("/")) {
                this.request.setURL("http://" + this.options.getString("muffin.host") + ":" + this.options.getString("muffin.port") + this.request.getURL());
            } else {
                if (this.request.getURL().startsWith("https://")) {
                    System.out.println("Netscape keep-alive bug: " + this.request.getURL());
                    return false;
                }
                if (!this.request.getURL().startsWith("http://")) {
                    System.out.println("Unknown URL: " + this.request.getURL());
                    return false;
                }
            }
            boolean bl3 = bl = this.request.containsHeaderField("Proxy-Connection") && this.request.getHeaderField("Proxy-Connection").equals("Keep-Alive");
            if (!this.options.getBoolean("muffin.passthru")) {
                object2 = this.redirect(this.request);
                if (object2 != null) {
                    object = Reply.createRedirect((String)object2);
                    this.client.write((Reply)object);
                    return bl;
                }
                this.filter(this.request);
            }
            this.http = this.createHttpFilter(this.request);
            if (this.http == null) {
                this.http = bl2 ? this.createHttpsRelay() : this.createHttpRelay();
            }
            try {
                this.http.sendRequest(this.request);
                this.reply = this.http.recvReply(this.request);
            }
            catch (RetryRequestException retryRequestException) {
                this.http.close();
                this.http = null;
                continue;
            }
            if (this.reply.headerCount() == 0 && (((String)(object2 = this.request.getURL())).endsWith("/") || ((String)object2).endsWith(".html") || ((String)object2).endsWith(".htm"))) {
                this.reply.setHeaderField("Content-type", "text/html");
            }
            this.monitor.update(this);
            if (!this.options.getBoolean("muffin.passthru")) {
                this.filter(this.reply);
            }
            this.reply.removeHeaderField("Proxy-Connection");
            if (bl && this.reply.containsHeaderField("Content-length")) {
                this.reply.setHeaderField("Proxy-Connection", "Keep-Alive");
            } else {
                bl = false;
            }
            this.currentLength = -1;
            this.contentLength = -1;
            try {
                this.contentLength = Integer.parseInt(this.reply.getHeaderField("Content-length"));
            }
            catch (NumberFormatException numberFormatException) {}
            this.monitor.update(this);
            if (bl2) {
                object2 = (Https)this.http;
                this.client.write(this.reply);
                object = new Copy(this.client.getInputStream(), ((HttpConnection)object2).getOutputStream());
                Thread thread = new Thread((Runnable)object);
                thread.start();
                this.flushCopy(((HttpConnection)object2).getInputStream(), this.client.getOutputStream(), -1, true);
                this.client.close();
            } else if (this.reply.hasContent()) {
                try {
                    this.processContent();
                }
                catch (IOException iOException) {
                    if (this.http instanceof Http) {
                        ((Http)this.http).reallyClose();
                    } else {
                        this.http.close();
                    }
                    this.http = null;
                    this.client.close();
                    this.client = null;
                    return false;
                }
                if (this.contentLength == 0) {
                    this.client.close();
                }
            } else {
                this.client.write(this.reply);
            }
            this.http.close();
        }
        return bl;
    }

    HttpRelay createHttpsRelay() throws IOException {
        Https https = this.options.useHttpsProxy() ? new Https(this.options.getString("muffin.httpsProxyHost"), this.options.getInteger("muffin.httpsProxyPort"), true) : new Https(this.request.getHost(), this.request.getPort());
        return https;
    }

    HttpRelay createHttpRelay() throws IOException {
        HttpConnection httpConnection;
        Object object = this.request;
        if (((Request)object).getHost().equalsIgnoreCase(Httpd.options.getString("muffin.host")) && (((Request)object).getPort() == Httpd.options.getInteger("muffin.port") || false)) {
            httpConnection = new Httpd(this.socket);
        } else if (this.options.useHttpProxy()) {
            httpConnection = Http.open(this.options.getString("muffin.httpProxyHost"), this.options.getInteger("muffin.httpProxyPort"), true);
        } else {
            object = this.request.getHost();
            int n = this.request.getPort();
            httpConnection = Http.open((String)object, n, false);
        }
        return httpConnection;
    }

    HttpRelay createHttpFilter(Request request) {
        int n = 0;
        while (n < this.filterList.length) {
            HttpFilter httpFilter;
            if (this.filterList[n] instanceof HttpFilter && (httpFilter = (HttpFilter)this.filterList[n]).wantRequest(request)) {
                return httpFilter;
            }
            ++n;
        }
        return null;
    }

    InputStream readChunkedTransfer(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        int n = 0;
        this.contentLength = 0;
        while ((n = this.reply.getChunkSize(inputStream)) > 0) {
            this.contentLength += n;
            this.copy(inputStream, byteArrayOutputStream, n, true);
            this.reply.readLine(inputStream);
        }
        this.reply.getChunkedFooter(inputStream);
        this.reply.removeHeaderField("Transfer-Encoding");
        this.reply.setHeaderField("Content-length", this.contentLength);
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    void processContent() throws IOException {
        InputStream inputStream;
        boolean bl = false;
        if (this.reply.containsHeaderField("Transfer-Encoding") && this.reply.getTransferEncoding().equals("chunked")) {
            inputStream = this.readChunkedTransfer(this.reply.getContent());
            bl = true;
        } else {
            inputStream = this.reply.getContent();
        }
        if (inputStream == null) {
            System.out.println("No inputstream");
            return;
        }
        if (this.options.getBoolean("muffin.passthru")) {
            this.client.write(this.reply);
            this.copy(inputStream, this.client.getOutputStream(), this.contentLength, true);
            return;
        }
        if (this.contentNeedsFiltration()) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
            this.filter(inputStream, byteArrayOutputStream, this.contentLength, !bl);
            this.reply.setHeaderField("Content-length", byteArrayOutputStream.size());
            this.client.write(this.reply);
            this.copy(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), this.client.getOutputStream(), byteArrayOutputStream.size(), false);
            return;
        }
        this.client.write(this.reply);
        this.copy(inputStream, this.client.getOutputStream(), this.contentLength, true);
    }

    String redirect(Request request) {
        int n = 0;
        while (n < this.filterList.length) {
            RedirectFilter redirectFilter;
            if (this.filterList[n] instanceof RedirectFilter && (redirectFilter = (RedirectFilter)this.filterList[n]).needsRedirection(request)) {
                String string = redirectFilter.redirect(request);
                return string;
            }
            ++n;
        }
        return null;
    }

    void filter(Reply reply) throws FilterException {
        int n = 0;
        while (n < this.filterList.length) {
            if (this.filterList[n] instanceof ReplyFilter) {
                ((ReplyFilter)this.filterList[n]).filter(reply);
            }
            ++n;
        }
    }

    void filter(Request request) throws FilterException {
        int n = 0;
        while (n < this.filterList.length) {
            if (this.filterList[n] instanceof RequestFilter) {
                ((RequestFilter)this.filterList[n]).filter(request);
            }
            ++n;
        }
    }

    boolean contentNeedsFiltration() {
        int n = 0;
        while (n < this.filterList.length) {
            ContentFilter contentFilter;
            if (this.filterList[n] instanceof ContentFilter && (contentFilter = (ContentFilter)this.filterList[n]).needsFiltration(this.request, this.reply)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void filter(InputStream inputStream, OutputStream outputStream, int n, boolean bl) throws IOException {
        Runnable runnable;
        InputObjectStream inputObjectStream = new InputObjectStream();
        SourceObjectStream sourceObjectStream = this.reply.containsHeaderField("Content-type") && this.reply.getContentType().equals("text/html") ? new HtmlObjectStream(inputObjectStream) : new SourceObjectStream(inputObjectStream);
        int n2 = 0;
        while (n2 < this.filterList.length) {
            if (this.filterList[n2] instanceof ContentFilter && (runnable = (ContentFilter)this.filterList[n2]).needsFiltration(this.request, this.reply)) {
                OutputObjectStream outputObjectStream = new OutputObjectStream();
                InputObjectStream inputObjectStream2 = new InputObjectStream(outputObjectStream);
                runnable.setInputObjectStream(inputObjectStream);
                runnable.setOutputObjectStream(outputObjectStream);
                Thread thread = new Thread(this.filterGroup, runnable);
                try {
                    thread.setPriority(1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                thread.start();
                inputObjectStream = inputObjectStream2;
            }
            ++n2;
        }
        sourceObjectStream.setSourceInputStream(inputStream);
        sourceObjectStream.setSourceLength(n);
        runnable = new Thread(sourceObjectStream);
        ((Thread)runnable).setName("ObjectStream Source (" + this.socket.getInetAddress() + ")");
        ((Thread)runnable).start();
        this.copy(inputObjectStream, outputStream, bl);
    }

    int getTotalBytes() {
        if (this.contentLength > 0) {
            return this.contentLength;
        }
        return 0;
    }

    int getCurrentBytes() {
        if (this.currentLength > 0) {
            return this.currentLength;
        }
        return 0;
    }

    void error(OutputStream outputStream, Exception exception, Request request) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("While trying to retrieve the URL: <a href=\"" + request.getURL() + "\">" + request.getURL() + "</a>\r\n");
        stringBuffer.append("<p>\r\nThe following error was encountered:\r\n<p>\r\n");
        stringBuffer.append("<ul><li>" + exception.toString() + "</ul>\r\n");
        String string = new HttpError(this.options, 400, stringBuffer.toString()).toString();
        try {
            outputStream.write(string.getBytes(), 0, string.length());
            outputStream.flush();
            return;
        }
        catch (Exception exception2) {
            return;
        }
    }

    void copy(InputStream inputStream, OutputStream outputStream, int n, boolean bl) throws IOException {
        int n2;
        if (n == 0) {
            return;
        }
        byte[] byArray = new byte[8192];
        long l = System.currentTimeMillis();
        this.bytesPerSecond = 0.0;
        if (bl) {
            this.currentLength = 0;
        }
        do {
            n2 = n > 0 ? Math.min(n, byArray.length) : byArray.length;
            if ((n2 = inputStream.read(byArray, 0, n2)) <= 0) break;
            outputStream.write(byArray, 0, n2);
            if (bl) {
                this.currentLength += n2;
                this.monitor.update(this);
            }
            this.bytesPerSecond = (double)this.currentLength / ((double)(System.currentTimeMillis() - l) / 1000.0);
        } while (n == -1 || (n -= n2) != 0);
        outputStream.flush();
    }

    void flushCopy(InputStream inputStream, OutputStream outputStream, int n, boolean bl) throws IOException {
        int n2;
        if (n == 0) {
            return;
        }
        byte[] byArray = new byte[8192];
        long l = System.currentTimeMillis();
        this.bytesPerSecond = 0.0;
        if (bl) {
            this.currentLength = 0;
        }
        do {
            n2 = n > 0 ? Math.min(n, byArray.length) : byArray.length;
            if ((n2 = inputStream.read(byArray, 0, n2)) <= 0) break;
            outputStream.write(byArray, 0, n2);
            outputStream.flush();
            if (bl) {
                this.currentLength += n2;
                this.monitor.update(this);
            }
            this.bytesPerSecond = (double)this.currentLength / ((double)(System.currentTimeMillis() - l) / 1000.0);
        } while (n == -1 || (n -= n2) != 0);
        outputStream.flush();
    }

    void copy(InputObjectStream inputObjectStream, OutputStream outputStream, boolean bl) throws IOException {
        Object object;
        long l = System.currentTimeMillis();
        this.bytesPerSecond = 0.0;
        if (bl) {
            this.currentLength = 0;
        }
        while ((object = inputObjectStream.read()) != null) {
            Object object2;
            if (object instanceof ByteArray) {
                object2 = (ByteArray)object;
                outputStream.write(((ByteArray)object2).getBytes(), 0, ((ByteArray)object2).length());
                this.currentLength += ((ByteArray)object2).length();
            } else if (object instanceof Byte) {
                object2 = (Byte)object;
                outputStream.write(((Byte)object2).byteValue());
                ++this.currentLength;
            } else {
                System.out.println("Unknown object: " + object.toString());
            }
            if (bl) {
                this.monitor.update(this);
            }
            this.bytesPerSecond = (double)this.currentLength / ((double)(System.currentTimeMillis() - l) / 1000.0);
        }
        outputStream.flush();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CLIENT ");
        stringBuffer.append(this.socket.getInetAddress());
        stringBuffer.append(":");
        stringBuffer.append(this.socket.getPort());
        stringBuffer.append(" - ");
        if (this.request == null) {
            stringBuffer.append("idle " + (double)(System.currentTimeMillis() - this.idle) / 1000.0 + " sec");
        } else {
            if (this.reply != null && this.currentLength > 0) {
                stringBuffer.append("(");
                stringBuffer.append(this.currentLength);
                if (this.contentLength > 0) {
                    stringBuffer.append("/");
                    stringBuffer.append(this.contentLength);
                }
                stringBuffer.append(" ");
                stringBuffer.append(String.valueOf((int)this.bytesPerSecond / 1024) + " kB/s");
                stringBuffer.append(") ");
            }
            stringBuffer.append(this.request.getURL());
        }
        return stringBuffer.toString();
    }
}

