/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.doit.muffin.HttpConnection;
import org.doit.muffin.Reply;
import org.doit.muffin.Request;
import org.doit.muffin.RetryRequestException;

class Http
extends HttpConnection {
    static final boolean DEBUG = false;
    static final int MAX_PENDING_REQUESTS = 1;
    static Hashtable cache = new Hashtable(33);
    String host;
    int port;
    boolean proxy = false;
    boolean persistent = false;
    boolean closed = false;
    long idle;
    Vector queue = new Vector();

    Http(String string, int n) throws IOException {
        this(string, n, false);
    }

    Http(String string, int n, boolean bl) throws IOException {
        super(string, n);
        this.host = string;
        this.port = n;
        this.proxy = bl;
    }

    public synchronized void sendRequest(Request request) throws IOException, RetryRequestException {
        this.queue.addElement(request);
        try {
            this.send(request);
            return;
        }
        catch (IOException iOException) {
            if (this.persistent) {
                this.persistent = false;
                throw new RetryRequestException();
            }
            throw iOException;
        }
    }

    public synchronized Reply recvReply(Request request) throws IOException, RetryRequestException {
        while (this.queue.firstElement() != request) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.closed) {
            throw new RetryRequestException();
        }
        try {
            return this.recv();
        }
        catch (IOException iOException) {
            if (this.persistent) {
                this.persistent = false;
                throw new RetryRequestException();
            }
            throw iOException;
        }
    }

    public void reallyClose() {
        this.persistent = false;
        this.close();
    }

    public synchronized void close() {
        if (this.persistent) {
            this.idle = System.currentTimeMillis();
        } else {
            Http.cacheRemove(this.host, this.port, this);
            super.close();
            this.closed = true;
        }
        if (this.queue.size() > 0) {
            this.queue.removeElementAt(0);
            this.notify();
        }
    }

    private void send(Request request) throws IOException {
        request.removeHeaderField("Proxy-Connection");
        request.setHeaderField("Connection", "open");
        if (!request.containsHeaderField("Host")) {
            request.setHeaderField("Host", request.getHost());
        }
        if (this.proxy) {
            request.write(this.getOutputStream());
            return;
        }
        String string = request.statusLine;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(request.getCommand());
        stringBuffer.append(" ");
        stringBuffer.append(request.getPath());
        stringBuffer.append(" ");
        stringBuffer.append("HTTP/1.1");
        request.statusLine = stringBuffer.toString();
        request.write(this.getOutputStream());
        request.statusLine = string;
    }

    private Reply recv() throws IOException {
        Reply reply = new Reply(this.getInputStream());
        reply.read();
        reply.getHeaderField("Connection");
        this.persistent = reply.containsHeaderField("Connection") && reply.getHeaderField("Connection").equals("close") ? false : reply.getProtocol().equals("HTTP/1.1");
        if (reply.getStatusCode() == 100) {
            reply = this.recv();
        }
        return reply;
    }

    private boolean isBusy() {
        return this.queue.size() >= 1;
    }

    private boolean isPersistent() {
        return this.persistent;
    }

    private static String cacheKey(String string, int n) {
        return String.valueOf(string.toLowerCase()) + ":" + n;
    }

    private static Vector cacheLookup(String string, int n) {
        Vector vector = (Vector)cache.get(Http.cacheKey(string, n));
        return vector;
    }

    private static boolean cacheContains(Http http) {
        Vector vector = (Vector)cache.get(Http.cacheKey(http.host, http.port));
        if (vector != null) {
            return vector.contains(http);
        }
        return false;
    }

    private static void cacheInsert(String string, int n, Http http) {
        String string2 = Http.cacheKey(string, n);
        Vector<Http> vector = (Vector<Http>)cache.get(string2);
        if (vector == null) {
            vector = new Vector<Http>();
        }
        vector.addElement(http);
        cache.put(string2, vector);
    }

    private static void cacheRemove(String string, int n, Http http) {
        Vector vector = (Vector)cache.get(Http.cacheKey(string, n));
        if (vector != null) {
            vector.removeElement(http);
            if (vector.isEmpty()) {
                cache.remove(Http.cacheKey(string, n));
            }
        }
    }

    private static void cacheClean() {
        long l = System.currentTimeMillis();
        Enumeration enumeration = cache.keys();
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)cache.get(enumeration.nextElement());
            int n = 0;
            while (n < vector.size()) {
                Http http = (Http)vector.elementAt(n);
                if (http.idle > 0L && l - http.idle > 30000L) {
                    http.persistent = false;
                    http.close();
                }
                ++n;
            }
        }
    }

    static synchronized Http open(String string, int n, boolean bl) throws IOException {
        Http http = null;
        Vector vector = Http.cacheLookup(string, n);
        if (vector != null) {
            int n2 = 0;
            while (n2 < vector.size()) {
                Http http2 = (Http)vector.elementAt(n2);
                if (http2.persistent && http2.queue.size() < 1) {
                    http = http2;
                    break;
                }
                ++n2;
            }
            if (http != null) {
                http.idle = 0L;
            }
        }
        if (http == null) {
            http = new Http(string, n, bl);
            Http.cacheInsert(string, n, http);
        }
        return http;
    }

    static Http open(String string, int n) throws IOException {
        return Http.open(string, n, false);
    }

    static Enumeration enumerate() {
        Vector vector = new Vector();
        Enumeration enumeration = cache.keys();
        while (enumeration.hasMoreElements()) {
            Vector vector2 = (Vector)cache.get(enumeration.nextElement());
            int n = 0;
            while (n < vector2.size()) {
                vector.addElement(vector2.elementAt(n));
                ++n;
            }
        }
        return vector.elements();
    }

    public static synchronized void clean() {
        Http.cacheClean();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SERVER ");
        stringBuffer.append(super.toString());
        if (this.persistent) {
            stringBuffer.append(" - ");
            if (this.queue.size() > 0) {
                stringBuffer.append(this.queue.size());
                stringBuffer.append(" pending");
            } else {
                stringBuffer.append("idle " + (double)(System.currentTimeMillis() - this.idle) / 1000.0 + " sec");
            }
        }
        return stringBuffer.toString();
    }
}

