/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import gnu.regexp.RE;
import gnu.regexp.REMatch;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import org.doit.muffin.MuffinFrame;

class RegexFrame
extends MuffinFrame
implements ActionListener,
WindowListener {
    TextArea text;
    TextField pattern;
    REMatch match;

    RegexFrame() {
        super("Muffin: Regular Expression Tester");
        Panel panel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        Label label = new Label("Regular Expression:", 2);
        panel.add(label);
        this.pattern = new TextField(32);
        panel.add(this.pattern);
        Button button = new Button("Match");
        button.setActionCommand("doMatch");
        button.addActionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        panel.add(button);
        this.add("North", panel);
        this.text = new TextArea();
        this.text.setEditable(true);
        this.text.setText("Insert sample text here...");
        this.add("Center", this.text);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 2));
        button = new Button("Clear");
        button.setActionCommand("doClear");
        button.addActionListener(this);
        panel2.add(button);
        button = new Button("Close");
        button.setActionCommand("doClose");
        button.addActionListener(this);
        panel2.add(button);
        this.add("South", panel2);
        this.addWindowListener(this);
        this.pack();
        ((Component)this).setSize(this.getPreferredSize());
        this.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("doClose".equals(string)) {
            ((Component)this).setVisible(false);
            return;
        }
        if ("doClear".equals(string)) {
            this.text.setText("");
            return;
        }
        if ("doMatch".equals(string)) {
            try {
                RE rE = new RE(this.pattern.getText());
                this.match = this.match != null ? rE.getMatch(this.text.getText(), this.match.getEndIndex(), this.text.getText().length()) : rE.getMatch(this.text.getText());
                if (this.match != null) {
                    this.text.select(this.match.getStartIndex(), this.match.getEndIndex());
                    return;
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
                return;
            }
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

