/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import java.io.DataOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.doit.muffin.FilterManager;
import org.doit.muffin.Handler;
import org.doit.muffin.HttpError;
import org.doit.muffin.Httpd;
import org.doit.muffin.Monitor;
import org.doit.muffin.Options;

class Server {
    static ThreadGroup handlers = null;
    ServerSocket server;
    Monitor monitor;
    FilterManager manager;
    Options options;
    boolean running = false;
    Thread thread;

    Server(int n, Monitor monitor, FilterManager filterManager, Options options) {
        try {
            this.server = new ServerSocket(n, 512);
        }
        catch (Exception exception) {
            System.out.println(exception);
            System.exit(0);
        }
        handlers = new ThreadGroup("Muffin Handlers");
        this.monitor = monitor;
        this.manager = filterManager;
        this.options = options;
        this.thread = Thread.currentThread();
        Monitor monitor2 = this.monitor;
        Httpd.options = options;
        Httpd.manager = filterManager;
        Httpd.monitor = monitor2;
        Httpd.server = this;
    }

    synchronized void suspend() {
        this.running = false;
        Thread[] threadArray = Server.getThreads();
        if (threadArray == null) {
            return;
        }
        int n = 0;
        while (n < threadArray.length) {
            threadArray[n].suspend();
            ++n;
        }
    }

    synchronized void resume() {
        this.running = true;
        Thread[] threadArray = Server.getThreads();
        if (threadArray == null) {
            return;
        }
        int n = 0;
        while (n < threadArray.length) {
            threadArray[n].resume();
            ++n;
        }
    }

    synchronized void stop() {
        Thread[] threadArray = Server.getThreads();
        if (threadArray == null) {
            return;
        }
        int n = 0;
        while (n < threadArray.length) {
            if (threadArray[n] instanceof Handler) {
                Handler handler = (Handler)threadArray[n];
                handler.flush();
                handler.close();
                handler.kill();
            } else {
                threadArray[n].stop();
            }
            ++n;
        }
    }

    static void clean() {
        Thread[] threadArray = Server.getThreads();
        if (threadArray == null) {
            return;
        }
        long l = System.currentTimeMillis();
        int n = 0;
        while (n < threadArray.length) {
            if (threadArray[n] instanceof Handler) {
                Handler handler = (Handler)threadArray[n];
                if (handler.idle > 0L && l - handler.idle > 300000L) {
                    handler.close();
                    handler.kill();
                }
            }
            ++n;
        }
    }

    static synchronized Thread[] getThreads() {
        int n = handlers.activeCount();
        if (n < 0) {
            return null;
        }
        Thread[] threadArray = new Thread[n];
        handlers.enumerate(threadArray);
        return threadArray;
    }

    void run() {
        this.thread.setName("Muffin Server");
        this.running = true;
        while (true) {
            Socket socket;
            try {
                socket = this.server.accept();
            }
            catch (Exception exception) {
                System.out.println(exception);
                continue;
            }
            if (!this.options.hostAccess(socket.getInetAddress())) {
                System.out.println(String.valueOf(socket.getInetAddress()) + ": access denied");
                this.error(socket, 403, "No muffins for you!");
                continue;
            }
            if (this.running) {
                Handler handler = new Handler(handlers, (Runnable)this.thread, this.monitor, this.manager, this.options);
                handler.doit(socket);
                continue;
            }
            this.error(socket, 503, "Muffin proxy service is suspended.");
        }
    }

    void error(Socket socket, int n, String string) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            dataOutputStream.writeBytes(new HttpError(this.options, n, string).toString());
            dataOutputStream.close();
            socket.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

