/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.doit.muffin.AutoSaveable;
import org.doit.muffin.Filter;
import org.doit.muffin.FilterFactory;
import org.doit.muffin.FilterManager;
import org.doit.muffin.Prefs;
import org.doit.muffin.filter.HistoryData;
import org.doit.muffin.filter.HistoryDataCountComparer;
import org.doit.muffin.filter.HistoryDataTimeComparer;
import org.doit.muffin.filter.HistoryFilter;
import sdsu.util.SortedList;

public class History
implements FilterFactory,
AutoSaveable {
    private Hashtable data;
    FilterManager manager;
    Prefs prefs;

    HistoryData get(String string) {
        HistoryData historyData = (HistoryData)this.data.get(string);
        if (historyData == null) {
            historyData = new HistoryData();
            historyData.url = string;
            historyData.time = 0L;
            historyData.count = 0L;
            this.put(string, historyData);
        }
        return historyData;
    }

    void put(String string, HistoryData historyData) {
        this.data.put(string, historyData);
    }

    Enumeration keys() {
        return this.data.keys();
    }

    Enumeration sortByCount() {
        SortedList sortedList = new SortedList(HistoryDataCountComparer.getInstance());
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            sortedList.addElement(this.get((String)enumeration.nextElement()));
        }
        return sortedList.elements();
    }

    Enumeration sortByTime() {
        SortedList sortedList = new SortedList(HistoryDataTimeComparer.getInstance());
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            sortedList.addElement(this.get((String)enumeration.nextElement()));
        }
        return sortedList.elements();
    }

    public void setManager(FilterManager filterManager) {
        this.manager = filterManager;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
        boolean bl = prefs.getOverride();
        prefs.setOverride(false);
        prefs.putString("History.histfile", "history");
        prefs.setOverride(bl);
        this.loadData();
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void viewPrefs() {
    }

    public Filter createFilter() {
        HistoryFilter historyFilter = new HistoryFilter(this);
        historyFilter.setPrefs(this.prefs);
        return historyFilter;
    }

    public void shutdown() {
        this.saveData();
    }

    public void autoSave() {
        History history = this;
        synchronized (history) {
            this.saveData();
            return;
        }
    }

    void save() {
        this.manager.save(this);
    }

    void loadData() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.prefs.getUserFile(this.prefs.getString("History.histfile")));
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            this.data = (Hashtable)objectInputStream.readObject();
            fileInputStream.close();
            return;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.data = new Hashtable();
            return;
        }
    }

    void saveData() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.prefs.getUserFile(this.prefs.getString("History.histfile")));
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.data);
            objectOutputStream.flush();
            fileOutputStream.close();
            return;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return;
        }
    }
}

