/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.doit.muffin.Prefs;
import org.doit.muffin.RedirectFilter;
import org.doit.muffin.Request;
import org.doit.muffin.filter.HostnameExpander;

public class HostnameExpanderFilter
implements RedirectFilter {
    Prefs prefs;
    HostnameExpander factory;

    HostnameExpanderFilter(HostnameExpander hostnameExpander) {
        this.factory = hostnameExpander;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public boolean needsRedirection(Request request) {
        String string = request.getHost();
        return string.indexOf(".") < 0;
    }

    public String redirect(Request request) {
        String string = this.prefs.getString("HostnameExpander.defaultDomain");
        String string2 = this.expandHostname(request.getHost());
        if (string2 == null && string.length() > 0) {
            string2 = request.getHost();
            if (!string.startsWith(".")) {
                string2 = String.valueOf(string2) + ".";
            }
            string2 = String.valueOf(string2) + string;
        }
        if (string2 != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("http://");
            stringBuffer.append(string2);
            if (request.getPort() != 80) {
                stringBuffer.append(":");
                stringBuffer.append(request.getPort());
            }
            stringBuffer.append(request.getPath());
            this.factory.process(String.valueOf(request.getHost()) + " -> " + stringBuffer.toString() + "\n");
            return stringBuffer.toString();
        }
        return null;
    }

    String expandHostname(String string) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            inetAddress = null;
        }
        if (inetAddress == null) {
            String[] stringArray = this.prefs.getStringList("HostnameExpander.prefix");
            String[] stringArray2 = this.prefs.getStringList("HostnameExpander.suffix");
            int n = 0;
            while (n < stringArray.length) {
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    String string2 = String.valueOf(stringArray[n]) + string + stringArray2[n2];
                    try {
                        inetAddress = InetAddress.getByName(string2);
                    }
                    catch (UnknownHostException unknownHostException) {
                        inetAddress = null;
                    }
                    if (inetAddress != null) {
                        return string2;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return null;
    }
}

