/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.doit.muffin.Filter;
import org.doit.muffin.FilterFactory;
import org.doit.muffin.FilterManager;
import org.doit.muffin.MessageArea;
import org.doit.muffin.Prefs;
import org.doit.muffin.filter.RewriteFilter;
import org.doit.muffin.filter.RewriteFrame;

public class Rewrite
implements FilterFactory {
    FilterManager manager;
    Prefs prefs;
    RewriteFrame frame;
    MessageArea messages;
    Vector rules;
    Vector rewrite;

    public void setManager(FilterManager filterManager) {
        this.manager = filterManager;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
        boolean bl = prefs.getOverride();
        prefs.setOverride(false);
        String string = prefs.getUserFile("rewrite");
        prefs.putString("Rewrite.rules", string);
        prefs.putInteger("Rewrite.historySize", 500);
        prefs.setOverride(bl);
        this.messages = new MessageArea(prefs.getInteger("Rewrite.historySize"));
        this.load();
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void viewPrefs() {
        if (this.frame == null) {
            this.frame = new RewriteFrame(this.prefs, this);
        }
        ((Component)this.frame).setVisible(true);
    }

    public Filter createFilter() {
        RewriteFilter rewriteFilter = new RewriteFilter(this);
        rewriteFilter.setPrefs(this.prefs);
        return rewriteFilter;
    }

    public void shutdown() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    void save() {
        this.manager.save(this);
    }

    String rewrite(String string) {
        RE rE = null;
        REMatch rEMatch = null;
        Enumeration enumeration = this.rules.elements();
        int n = 0;
        while (rEMatch == null && enumeration.hasMoreElements()) {
            rE = (RE)enumeration.nextElement();
            rEMatch = rE.getMatch(string);
            ++n;
        }
        if (rEMatch != null) {
            String string2 = (String)this.rewrite.elementAt(n - 1);
            try {
                String string3 = rEMatch.substituteInto(string2);
                this.process("RULE #" + n + ": " + string + " -> " + string3 + "\n");
                string = string3;
            }
            catch (REException rEException) {
                System.out.println("rewrite: " + rEException);
            }
        }
        return string;
    }

    void load() {
        String string = this.prefs.getUserFile(this.prefs.getString("Rewrite.rules"));
        try {
            this.load(new FileReader(new File(string)));
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    void load(Reader reader) {
        this.rules = new Vector();
        this.rewrite = new Vector();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(reader);
            RE rE = new RE("^[# \t\n]");
            while ((string = bufferedReader.readLine()) != null) {
                if (rE.getMatch(string) != null) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
                try {
                    this.rules.addElement(new RE(stringTokenizer.nextToken()));
                    this.rewrite.addElement(stringTokenizer.nextToken());
                }
                catch (REException rEException) {
                    System.out.println("REException: " + rEException);
                }
            }
            bufferedReader.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    void process(String string) {
        this.messages.append(string);
    }
}

