/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.REException;
import java.io.Serializable;

public class REMatch
implements Serializable {
    private String refString;
    int index;
    int[] start;
    int[] end;
    int[] count;

    void clear() {
        int n = 0;
        while (n < this.start.length) {
            this.end[n] = -1;
            this.start[n] = -1;
            this.count[n] = 0;
            ++n;
        }
    }

    REMatch(String string, int n, int n2) {
        this.refString = string;
        this.start = new int[n + 1];
        this.end = new int[n + 1];
        this.count = new int[n + 1];
        this.clear();
        this.index = n2;
    }

    public String toString() {
        if (this.start[0] == -1) {
            return null;
        }
        return this.refString.substring(this.start[0], this.end[0]);
    }

    public int getStartIndex() {
        return this.start[0];
    }

    public int getSubStartIndex(int n) {
        if (n < this.start.length) {
            return this.start[n];
        }
        return -1;
    }

    public int getEndIndex() {
        return this.end[0];
    }

    public int getSubEndIndex(int n) {
        if (n < this.start.length) {
            return this.end[n];
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String substituteInto(String string) throws REException {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (cArray[n] == '$') {
                if (Character.isDigit(cArray[n + 1])) {
                    int n2;
                    if ((n2 = Character.digit(cArray[++n], 10)) >= this.start.length) throw new REException("no such subexpression", 8, n2);
                    stringBuffer.append(this.refString.substring(this.start[n2], this.end[n2]));
                }
            } else {
                stringBuffer.append(cArray[n]);
            }
            ++n;
        }
        return new String(stringBuffer);
    }
}

