/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import org.doit.muffin.FilterFactory;
import org.doit.muffin.FilterManager;
import org.doit.muffin.Http;
import org.doit.muffin.HttpConnection;
import org.doit.muffin.HttpError;
import org.doit.muffin.Monitor;
import org.doit.muffin.Options;
import org.doit.muffin.Prefs;
import org.doit.muffin.Reply;
import org.doit.muffin.Request;
import org.doit.muffin.RetryRequestException;
import org.doit.muffin.Server;
import org.doit.util.Base64;

class Httpd
extends HttpConnection {
    static Options options = null;
    static FilterManager manager = null;
    static Monitor monitor = null;
    static Server server = null;
    Request request;

    Httpd(Socket socket) throws IOException {
        super(socket);
    }

    public void sendRequest(Request request) throws IOException, RetryRequestException {
        this.request = request;
    }

    String decode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '+') {
                stringBuffer.append(" ");
            } else if (c == '%') {
                try {
                    int n2 = Integer.parseInt(string.substring(n + 1, n + 3), 16);
                    stringBuffer.append((char)n2);
                }
                catch (Exception exception) {}
                n += 2;
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    String getDateString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        TimeZone timeZone = TimeZone.getDefault();
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String string = simpleDateFormat.format(new Date());
        return string;
    }

    static String head(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<title>" + string + "</title><body bgcolor=" + options.getString("muffin.bg") + " text=" + options.getString("muffin.fg") + ">\n");
        stringBuffer.append("<h1>" + string + "</h1>\n");
        stringBuffer.append("<hr size=4 noshade>\n");
        return stringBuffer.toString();
    }

    static String tail() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<p><hr size=4 noshade>\n");
        stringBuffer.append(Httpd.getGenerated());
        stringBuffer.append("</body>\n");
        return stringBuffer.toString();
    }

    String admin() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Httpd.head("Muffin: Remote Admin"));
        stringBuffer.append("<ul>\n");
        stringBuffer.append("<li><a href=/admin/configs>Configurations</a>\n");
        stringBuffer.append("<li><a href=/admin/connections>Connections</a>\n");
        stringBuffer.append("<li><a href=/admin/vm>Virtual Machine</a>\n");
        stringBuffer.append("</ul>\n");
        stringBuffer.append(Httpd.tail());
        return stringBuffer.toString();
    }

    String configs() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Httpd.head("Muffin: Configurations"));
        stringBuffer.append("<ul>\n");
        Enumeration enumeration = Httpd.manager.configs.sortedKeys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append("<li>");
            stringBuffer.append("<a href=/admin/filters?config=" + string + ">");
            stringBuffer.append(string);
            stringBuffer.append("</a>");
            stringBuffer.append("\n");
        }
        stringBuffer.append("</ul>\n");
        stringBuffer.append("<form method=POST action=/admin/createConfig>\n");
        stringBuffer.append("<input name=config type=text size=10>\n");
        stringBuffer.append("<input type=submit value=New>\n");
        stringBuffer.append("</form>\n");
        stringBuffer.append("<p><hr><b>Auto Configuration</b></b><br>\n");
        stringBuffer.append("<form method=POST action=/admin/autoConfig>\n");
        stringBuffer.append("<textarea name=text rows=10 cols=50>\n");
        int n = 0;
        while (n < Httpd.manager.configs.autoConfigPatterns.size()) {
            stringBuffer.append(Httpd.manager.configs.autoConfigPatterns.elementAt(n).toString());
            stringBuffer.append("\t");
            stringBuffer.append(Httpd.manager.configs.autoConfigNames.elementAt(n).toString());
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append("</textarea>\n");
        stringBuffer.append("<br><input type=submit value=Apply>\n");
        stringBuffer.append("</form>\n");
        stringBuffer.append(Httpd.tail());
        return stringBuffer.toString();
    }

    String connections() {
        Object e;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Httpd.head("Muffin: Connections"));
        Enumeration enumeration = monitor.enumerate();
        while (enumeration.hasMoreElements()) {
            e = enumeration.nextElement();
            stringBuffer.append(e.toString());
            stringBuffer.append("<br>\n");
        }
        enumeration = Http.enumerate();
        while (enumeration.hasMoreElements()) {
            e = enumeration.nextElement();
            stringBuffer.append(e.toString());
            stringBuffer.append("<br>\n");
        }
        stringBuffer.append(Httpd.tail());
        return stringBuffer.toString();
    }

    String filters(String string) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Httpd.head("Muffin: Filters " + string));
        Vector vector = manager.getKnownFilters(string);
        Vector vector2 = manager.getEnabledFilters(string);
        stringBuffer.append("<table><tr><td>\n");
        stringBuffer.append("<h2>Known Filters</h2>\n");
        stringBuffer.append("<form method=POST action=/admin/enable>\n");
        stringBuffer.append("<input type=hidden name=config value=\"" + string + "\">\n");
        stringBuffer.append("<select size=10 name=filter>\n");
        int n = 0;
        while (n < vector.size()) {
            stringBuffer.append("<option>" + (String)vector.elementAt(n) + "\n");
            ++n;
        }
        stringBuffer.append("</select>\n");
        stringBuffer.append("<br><input type=submit value=Enable>\n");
        stringBuffer.append("</form>\n");
        stringBuffer.append("</td><td>\n");
        stringBuffer.append("<h2>Enabled Filters</h2>\n");
        stringBuffer.append("<form method=POST action=/admin/disable>\n");
        stringBuffer.append("<input type=hidden name=config value=\"" + string + "\">\n");
        stringBuffer.append("<select size=10 name=index>\n");
        int n2 = 0;
        while (n2 < vector2.size()) {
            FilterFactory filterFactory = (FilterFactory)vector2.elementAt(n2);
            object = manager.shortName(filterFactory.getClass().getName());
            stringBuffer.append("<option value=" + n2 + ">" + (String)object + "\n");
            ++n2;
        }
        stringBuffer.append("</select>\n");
        stringBuffer.append("<br>");
        stringBuffer.append("<input type=submit value=Disable>\n");
        stringBuffer.append("</form>\n");
        stringBuffer.append("</td></tr></table>\n");
        int n3 = 0;
        while (n3 < vector2.size()) {
            object = (FilterFactory)vector2.elementAt(n3);
            String string2 = manager.shortName(object.getClass().getName());
            Prefs prefs = object.getPrefs();
            stringBuffer.append("<hr>\n");
            stringBuffer.append("<h2>" + string2 + "</h2>");
            stringBuffer.append("<a href=/doc/" + string2.substring(string2.lastIndexOf(".") + 1) + ".txt>[Help]</a><br>\n");
            if (prefs.isEmpty()) {
                stringBuffer.append("No Preferences.\n");
            } else {
                stringBuffer.append("<form method=POST action=/admin/set>\n");
                stringBuffer.append("<input type=hidden name=config value=\"" + string + "\">\n");
                stringBuffer.append("<input type=hidden name=filter value=\"" + string2 + "\">\n");
                stringBuffer.append("<table>\n");
                Enumeration enumeration = prefs.sortedKeys();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    String string4 = (String)prefs.get(string3);
                    stringBuffer.append("<tr><td>" + string3 + "</td>");
                    stringBuffer.append("<td><input name=\"" + string3 + "\" size=" + string4.length() + " type=text value='" + string4 + "'></input></td></tr>\n");
                }
                stringBuffer.append("</table>\n");
                stringBuffer.append("<br><input type=submit value=Submit><input type=reset value=Reset>\n");
                stringBuffer.append("</form>");
            }
            ++n3;
        }
        stringBuffer.append(Httpd.tail());
        return stringBuffer.toString();
    }

    String vm() {
        Runtime runtime = Runtime.getRuntime();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Httpd.head("Muffin: Virtual Machine"));
        stringBuffer.append("<table>\n");
        stringBuffer.append("<tr><td>free memory</td><td>" + runtime.freeMemory() + "</td></tr>\n");
        stringBuffer.append("<tr><td>total memory</td><td>" + runtime.totalMemory() + "</td></tr>\n");
        stringBuffer.append("<tr><td>java.version</td><td>" + System.getProperty("java.version") + "</td></tr>\n");
        stringBuffer.append("<tr><td>java.class.version</td><td>" + System.getProperty("java.class.version") + "</td></tr>\n");
        stringBuffer.append("<tr><td>java.class.path</td><td>" + System.getProperty("java.class.path") + "</td></tr>\n");
        stringBuffer.append("<tr><td>java.home</td><td>" + System.getProperty("java.home") + "</td></tr>\n");
        stringBuffer.append("<tr><td>java.vendor</td><td>" + System.getProperty("java.vendor") + "</td></tr>\n");
        stringBuffer.append("<tr><td>os.version</td><td>" + System.getProperty("os.version") + "</td></tr>\n");
        stringBuffer.append("<tr><td>os.arch</td><td>" + System.getProperty("os.arch") + "</td></tr>\n");
        stringBuffer.append("<tr><td>os.name</td><td>" + System.getProperty("os.name") + "</td></tr>\n");
        stringBuffer.append("<tr><td>user.name</td><td>" + System.getProperty("user.name") + "</td></tr>\n");
        stringBuffer.append("<tr><td>user.dir</td><td>" + System.getProperty("user.dir") + "</td></tr>\n");
        stringBuffer.append("<tr><td>user.home</td><td>" + System.getProperty("user.home") + "</td></tr>\n");
        stringBuffer.append("</table>\n");
        stringBuffer.append(Httpd.tail());
        return stringBuffer.toString();
    }

    Hashtable cgi(Request request) {
        String string;
        String string2;
        String string3;
        StringTokenizer stringTokenizer;
        Hashtable<String, String> hashtable = new Hashtable<String, String>(13);
        String string4 = request.getQueryString();
        String string5 = request.getData();
        if (string4 != null) {
            stringTokenizer = new StringTokenizer(this.decode(string4), "&");
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                string2 = string3.substring(0, string3.indexOf(61));
                string = string3.substring(string3.indexOf(61) + 1);
                hashtable.put(string2, string);
            }
        }
        if (string5 != null) {
            stringTokenizer = new StringTokenizer(this.decode(string5), "&");
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                string2 = string3.substring(0, string3.indexOf(61));
                string = string3.substring(string3.indexOf(61) + 1);
                hashtable.put(string2, string);
            }
        }
        return hashtable;
    }

    boolean authenticated(Request request) {
        String string = request.getHeaderField("Authorization");
        if (string == null || string.length() == 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string2 = stringTokenizer.nextToken();
        if (!string2.equalsIgnoreCase("basic")) {
            return false;
        }
        String string3 = Base64.base64Decode(stringTokenizer.nextToken());
        stringTokenizer = new StringTokenizer(string3, ":");
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        return string4 != null && string4.equals(options.getString("muffin.adminUser")) && string5 != null && string5.equals(options.getString("muffin.adminPassword"));
    }

    public Reply recvReply(Request request) throws IOException, RetryRequestException {
        Reply reply = new Reply(this.getInputStream());
        reply.setHeaderField("Server", "Muffin/" + options.getString("muffin.version"));
        reply.setHeaderField("Date", this.getDateString());
        if (request.getPath().startsWith("/images/")) {
            String string = request.getPath().substring(1);
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            reply.statusLine = "HTTP/1.0 200 Ok";
            reply.setHeaderField("Content-type", "image/jpeg");
            reply.setContent(inputStream);
        } else if (request.getPath().startsWith("/doc/")) {
            String string = request.getPath().substring(1);
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            reply.statusLine = "HTTP/1.0 200 Ok";
            if (string.endsWith(".html")) {
                reply.setHeaderField("Content-type", "text/html");
            } else {
                reply.setHeaderField("Content-type", "text/plain");
            }
            reply.setContent(inputStream);
        } else if (!options.adminInetAccess(this.getInetAddress())) {
            HttpError httpError = new HttpError(options, 403, "Administrative access denied");
            reply = httpError.getReply();
            reply.setContent(new ByteArrayInputStream(httpError.getContent().getBytes()));
        } else if (options.getString("muffin.adminUser").length() > 0 && options.getString("muffin.adminPassword").length() > 0 && !this.authenticated(request)) {
            HttpError httpError = new HttpError(options, 401, "Administrative access unauthorized");
            reply = httpError.getReply();
            reply.setHeaderField("WWW-Authenticate", "Basic realm=\"MuffinAdmin\"");
            reply.setContent(new ByteArrayInputStream(httpError.getContent().getBytes()));
        } else if (request.getPath().equals("/")) {
            byte[] byArray = this.admin().getBytes();
            reply.statusLine = "HTTP/1.0 200 Ok";
            reply.setHeaderField("Content-type", "text/html");
            reply.setHeaderField("Content-length", Integer.toString(byArray.length));
            reply.setContent(new ByteArrayInputStream(byArray));
        } else if (request.getPath().equals("/admin/autoConfig")) {
            Hashtable hashtable = this.cgi(request);
            String string = (String)hashtable.get("text");
            System.out.println("text=" + string);
            if (string != null) {
                Httpd.manager.configs.load(new StringReader(string));
            }
            reply = Reply.createRedirect("/admin/configs");
            byte[] byArray = new String("Document Moved").getBytes();
            reply.setContent(new ByteArrayInputStream(byArray));
        } else if (request.getPath().equals("/admin/configs")) {
            byte[] byArray = this.configs().getBytes();
            reply.statusLine = "HTTP/1.0 200 Ok";
            reply.setHeaderField("Content-type", "text/html");
            reply.setHeaderField("Content-length", Integer.toString(byArray.length));
            reply.setContent(new ByteArrayInputStream(byArray));
        } else if (request.getPath().equals("/admin/connections")) {
            byte[] byArray = this.connections().getBytes();
            reply.statusLine = "HTTP/1.0 200 Ok";
            reply.setHeaderField("Content-type", "text/html");
            reply.setHeaderField("Content-length", Integer.toString(byArray.length));
            reply.setContent(new ByteArrayInputStream(byArray));
        } else if (request.getPath().equals("/admin/createConfig")) {
            Hashtable hashtable = this.cgi(request);
            String string = (String)hashtable.get("config");
            if (string != null) {
                string.trim();
                Httpd.manager.configs.createConfig(string);
            }
            reply = Reply.createRedirect("/admin/configs");
            byte[] byArray = new String("Document Moved").getBytes();
            reply.setContent(new ByteArrayInputStream(byArray));
        } else if (request.getPath().startsWith("/admin/filters")) {
            Hashtable hashtable = this.cgi(request);
            String string = (String)hashtable.get("config");
            if (string != null) {
                string.trim();
                Httpd.manager.configs.createConfig(string);
            }
            byte[] byArray = this.filters(string).getBytes();
            reply.statusLine = "HTTP/1.0 200 Ok";
            reply.setHeaderField("Content-type", "text/html");
            reply.setHeaderField("Content-length", Integer.toString(byArray.length));
            reply.setContent(new ByteArrayInputStream(byArray));
        } else if (request.getPath().equals("/admin/vm")) {
            byte[] byArray = this.vm().getBytes();
            reply.statusLine = "HTTP/1.0 200 Ok";
            reply.setHeaderField("Content-type", "text/html");
            reply.setHeaderField("Content-length", Integer.toString(byArray.length));
            reply.setContent(new ByteArrayInputStream(byArray));
        } else if (request.getPath().equals("/admin/enable")) {
            Hashtable hashtable = this.cgi(request);
            String string = (String)hashtable.get("config");
            String string2 = (String)hashtable.get("filter");
            if (string != null && string2 != null) {
                manager.enable(string, string2);
            }
            reply = Reply.createRedirect("/admin/filters?config=" + string);
            byte[] byArray = new String("Document Moved").getBytes();
            reply.setContent(new ByteArrayInputStream(byArray));
        } else if (request.getPath().equals("/admin/disable")) {
            Hashtable hashtable = this.cgi(request);
            String string = (String)hashtable.get("config");
            String string3 = (String)hashtable.get("index");
            int n = -1;
            try {
                n = Integer.parseInt(string3);
            }
            catch (Exception exception) {}
            if (string != null && n != -1) {
                manager.disable(string, n);
            }
            reply = Reply.createRedirect("/admin/filters?config=" + string);
            byte[] byArray = new String("Document Moved").getBytes();
            reply.setContent(new ByteArrayInputStream(byArray));
        } else if (request.getPath().equals("/admin/set")) {
            Object object;
            Hashtable hashtable = this.cgi(request);
            String string = (String)hashtable.get("config");
            String string4 = (String)hashtable.get("filter");
            hashtable.remove("config");
            hashtable.remove("filter");
            if (string != null && string4 != null && hashtable.size() > 0) {
                Object object2;
                Object object3;
                object = manager.getEnabledFilters(string);
                Object object4 = null;
                int n = 0;
                while (n < ((Vector)object).size()) {
                    object3 = (FilterFactory)((Vector)object).elementAt(n);
                    object2 = manager.shortName(object3.getClass().getName());
                    if (((String)object2).equals(string4)) {
                        object4 = object3;
                        break;
                    }
                    ++n;
                }
                if (object4 != null) {
                    object3 = object4.getPrefs();
                    object2 = hashtable.keys();
                    while (object2.hasMoreElements()) {
                        String string5 = (String)object2.nextElement();
                        ((Prefs)object3).put(string5, (String)hashtable.get(string5));
                    }
                }
            }
            reply = Reply.createRedirect("/admin/filters?config=" + string);
            object = new String("Document Moved").getBytes();
            reply.setContent(new ByteArrayInputStream((byte[])object));
        } else {
            HttpError httpError = new HttpError(options, 404, String.valueOf(request.getPath()) + " not found");
            reply = httpError.getReply();
            reply.setContent(new ByteArrayInputStream(httpError.getContent().getBytes()));
        }
        return reply;
    }

    static void init(Options options, FilterManager filterManager, Monitor monitor, Server server) {
        Httpd.options = options;
        manager = filterManager;
        Httpd.monitor = monitor;
        Httpd.server = server;
    }

    static boolean sendme(Request request) {
        return request.getHost().equalsIgnoreCase(options.getString("muffin.host")) && request.getPort() == options.getInteger("muffin.port");
    }

    static String getLocation() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("http://");
        stringBuffer.append(options.getString("muffin.host"));
        stringBuffer.append(":");
        stringBuffer.append(options.getString("muffin.port"));
        return stringBuffer.toString();
    }

    static String getGenerated() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<a href=\"" + options.getString("muffin.url") + "\">");
        stringBuffer.append("<i><img border=0 alt=\"\" src=\"" + Httpd.getLocation() + "/images/mufficon.jpg\">");
        stringBuffer.append("Generated by Muffin " + options.getString("muffin.version") + "</a></i>");
        stringBuffer.append("</a>\n");
        return stringBuffer.toString();
    }
}

