/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.doit.muffin.Key;

abstract class Message {
    private Hashtable headers = new Hashtable(33);
    String statusLine;

    String readLine(InputStream inputStream) throws IOException {
        int n;
        char[] cArray = new char[128];
        int n2 = 0;
        while ((n = inputStream.read()) != -1 && n != 10) {
            if (n == 13) {
                int n3 = inputStream.read();
                if (n3 == 10) break;
                if (!(inputStream instanceof PushbackInputStream)) {
                    inputStream = new PushbackInputStream(inputStream);
                }
                ((PushbackInputStream)inputStream).unread(n3);
                break;
            }
            if (n2 == cArray.length) {
                char[] cArray2 = cArray;
                cArray = new char[cArray2.length * 2];
                System.arraycopy(cArray2, 0, cArray, 0, n2);
            }
            cArray[n2++] = (char)n;
        }
        return String.copyValueOf(cArray, 0, n2);
    }

    void readHeaders(InputStream inputStream) throws IOException {
        String string;
        Key key = null;
        while ((string = this.readLine(inputStream)) != null) {
            int n = string.indexOf(58);
            if (n == -1) {
                if (string.length() == 0) {
                    return;
                }
                if (key == null || !string.startsWith(" ") && !string.startsWith("\t")) continue;
                int n2 = this.getHeaderValueCount(key.toString());
                Vector vector = (Vector)this.headers.get(key);
                vector.setElementAt(String.valueOf(vector.elementAt(--n2)) + "\n" + string, n2);
                continue;
            }
            key = new Key(string.substring(0, n));
            Vector vector = this.headers.containsKey(key) ? (Vector)this.headers.get(key) : new Vector();
            vector.addElement(string.substring(n + 1).trim());
            this.headers.put(key, vector);
        }
    }

    public int headerCount() {
        return this.headers.size();
    }

    public void setStatusLine(String string) {
        this.statusLine = string;
    }

    public int getHeaderValueCount(String string) {
        Vector vector = (Vector)this.headers.get(new Key(string));
        return vector.size();
    }

    public String getHeaderField(String string) {
        return this.getHeaderField(string, 0);
    }

    public String getHeaderField(String string, int n) {
        Vector vector = (Vector)this.headers.get(new Key(string));
        if (vector == null) {
            return null;
        }
        return (String)vector.elementAt(n);
    }

    public void setHeaderField(String string, String string2) {
        this.setHeaderField(string, string2, 0);
    }

    public void setHeaderField(String string, String string2, int n) {
        Vector vector;
        Key key = new Key(string);
        if (this.headers.containsKey(key)) {
            vector = (Vector)this.headers.get(key);
        } else {
            vector = new Vector();
            if (n == 0) {
                vector.addElement("");
            }
            this.headers.put(key, vector);
        }
        vector.setElementAt(string2, n);
    }

    public void setHeaderField(String string, int n) {
        this.setHeaderField(string, n, 0);
    }

    public void setHeaderField(String string, int n, int n2) {
        this.setHeaderField(string, new Integer(n).toString(), n2);
    }

    public void appendHeaderField(String string, String string2) {
        this.appendHeaderField(string, string2, 0);
    }

    public void appendHeaderField(String string, String string2, int n) {
        this.setHeaderField(string, String.valueOf(this.getHeaderField(string, n)) + string2, n);
    }

    public void removeHeaderField(String string) {
        this.headers.remove(new Key(string));
    }

    public boolean containsHeaderField(String string) {
        return this.headers.containsKey(new Key(string));
    }

    public Enumeration getHeaders() {
        return this.headers.keys();
    }

    public String toString() {
        return this.toString("\r\n");
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        stringBuffer.append(this.statusLine);
        stringBuffer.append(string);
        Enumeration enumeration = this.headers.keys();
        while (enumeration.hasMoreElements()) {
            Key key = (Key)enumeration.nextElement();
            Vector vector = (Vector)this.headers.get(key);
            n = 0;
            while (n < vector.size()) {
                stringBuffer.append(String.valueOf(key) + ": " + vector.elementAt(n) + string);
                ++n;
            }
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    Message() {
    }
}

