/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import gnu.regexp.RE;
import java.awt.Component;
import org.doit.muffin.Filter;
import org.doit.muffin.FilterFactory;
import org.doit.muffin.FilterManager;
import org.doit.muffin.MessageArea;
import org.doit.muffin.Prefs;
import org.doit.muffin.filter.DecafFilter;
import org.doit.muffin.filter.DecafFrame;

public class Decaf
implements FilterFactory {
    FilterManager manager;
    Prefs prefs;
    DecafFrame frame;
    MessageArea messages;
    private RE javaScriptTags;
    private RE javaScriptAttrs;

    public void setManager(FilterManager filterManager) {
        this.manager = filterManager;
        try {
            this.javaScriptTags = new RE("^(a|input|body|form|area|select|frameset|label|textarea|button|applet|base|basefont|bdo|br|font|frame|head|html|iframe|isindex|meta|param|script|style|title)$");
            this.javaScriptAttrs = new RE("^(onload|onunload|onclick|ondblclick|onmousedown|onmouseup|onmouseover|onmousemove|onmouseout|onfocus|onblur|onkeypress|onkeydown|onkeyup|onsubmit|onreset|onselect|onchange)$");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
        boolean bl = prefs.getOverride();
        prefs.setOverride(false);
        prefs.putBoolean("Decaf.noJavaScript", true);
        prefs.putBoolean("Decaf.noJava", false);
        prefs.putInteger("Decaf.historySize", 500);
        prefs.setOverride(bl);
        this.messages = new MessageArea(prefs.getInteger("Decaf.historySize"));
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void viewPrefs() {
        if (this.frame == null) {
            this.frame = new DecafFrame(this.prefs, this);
        }
        ((Component)this.frame).setVisible(true);
    }

    public Filter createFilter() {
        DecafFilter decafFilter = new DecafFilter(this);
        decafFilter.setPrefs(this.prefs);
        return decafFilter;
    }

    public void shutdown() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    public boolean isJavaScriptTag(String string) {
        return this.javaScriptTags.getMatch(string) != null;
    }

    public boolean isJavaScriptAttr(String string) {
        return this.javaScriptAttrs.getMatch(string) != null;
    }

    void save() {
        this.manager.save(this);
    }

    void process(String string) {
        this.messages.append(string);
    }
}

