/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import org.doit.html.Tag;
import org.doit.html.Token;
import org.doit.io.InputObjectStream;
import org.doit.io.OutputObjectStream;
import org.doit.muffin.ContentFilter;
import org.doit.muffin.Prefs;
import org.doit.muffin.Reply;
import org.doit.muffin.Request;
import org.doit.muffin.filter.EmptyFont;

public class EmptyFontFilter
implements ContentFilter {
    EmptyFont factory;
    Prefs prefs;
    InputObjectStream in;
    OutputObjectStream out;

    EmptyFontFilter(EmptyFont emptyFont) {
        this.factory = emptyFont;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public boolean needsFiltration(Request request, Reply reply) {
        String string = reply.getContentType();
        return string != null && string.startsWith("text/html");
    }

    public void setInputObjectStream(InputObjectStream inputObjectStream) {
        this.in = inputObjectStream;
    }

    public void setOutputObjectStream(OutputObjectStream outputObjectStream) {
        this.out = outputObjectStream;
    }

    public void run() {
        Thread.currentThread().setName("EmptyFont");
        try {
            Object object;
            Token token = null;
            while ((object = this.in.read()) != null) {
                Token token2 = (Token)object;
                if (token2.getType() == 2) {
                    Tag tag = token2.createTag();
                    if (tag.is("font")) {
                        if (token != null) {
                            this.out.write(token);
                        }
                        token = token2;
                        continue;
                    }
                    if (tag.is("/font") && token != null) {
                        token = null;
                        continue;
                    }
                    if (token != null) {
                        this.out.write(token);
                        token = null;
                    }
                    this.out.write(token2);
                    continue;
                }
                if (token2.getType() == 4) {
                    this.out.write(token2);
                    continue;
                }
                if (token != null) {
                    boolean bl = true;
                    byte[] byArray = token2.getBytes();
                    int n = 0;
                    while (n < token2.length() && bl) {
                        if (byArray[n] > 32) {
                            bl = false;
                        }
                        ++n;
                    }
                    if (!bl) {
                        this.out.write(token);
                        token = null;
                    }
                }
                this.out.write(token2);
            }
            this.out.flush();
            this.out.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

