/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import gnu.regexp.RE;
import gnu.regexp.REException;
import java.awt.Component;
import org.doit.muffin.Filter;
import org.doit.muffin.FilterFactory;
import org.doit.muffin.FilterManager;
import org.doit.muffin.MessageArea;
import org.doit.muffin.Prefs;
import org.doit.muffin.filter.ImageKillFilter;
import org.doit.muffin.filter.ImageKillFrame;

public class ImageKill
implements FilterFactory {
    FilterManager manager;
    Prefs prefs;
    ImageKillFrame frame;
    MessageArea messages;
    private RE exclude;

    public void setManager(FilterManager filterManager) {
        this.manager = filterManager;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
        boolean bl = prefs.getOverride();
        prefs.setOverride(false);
        prefs.putInteger("ImageKill.minheight", 10);
        prefs.putInteger("ImageKill.minwidth", 100);
        prefs.putInteger("ImageKill.ratio", 5);
        prefs.putBoolean("ImageKill.keepmaps", true);
        prefs.putString("ImageKill.exclude", "(button|map)");
        prefs.putInteger("ImageKill.historySize", 500);
        prefs.setOverride(bl);
        this.messages = new MessageArea(prefs.getInteger("ImageKill.historySize"));
        this.setExclude();
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void viewPrefs() {
        if (this.frame == null) {
            this.frame = new ImageKillFrame(this.prefs, this);
        }
        ((Component)this.frame).setVisible(true);
    }

    public Filter createFilter() {
        ImageKillFilter imageKillFilter = new ImageKillFilter(this);
        imageKillFilter.setPrefs(this.prefs);
        return imageKillFilter;
    }

    public void shutdown() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    void save() {
        this.manager.save(this);
    }

    void process(String string) {
        this.messages.append(string);
    }

    boolean isExcluded(String string) {
        return this.exclude != null && this.exclude.getMatch(string) != null;
    }

    public void setExclude() {
        this.exclude = null;
        String string = this.prefs.getString("ImageKill.exclude");
        if (string != null && !string.equals("")) {
            try {
                this.exclude = new RE(string);
                return;
            }
            catch (REException rEException) {
                System.out.println("NoThanks REException: " + rEException.getMessage());
                return;
            }
        }
    }
}

