/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import org.doit.muffin.BigList;
import org.doit.muffin.ConfigurationListener;
import org.doit.muffin.FilterFactory;
import org.doit.muffin.FilterManager;
import org.doit.muffin.HelpFrame;
import org.doit.muffin.MuffinFrame;
import org.doit.util.TextDialog;
import sdsu.compare.StringIgnoreCaseComparer;
import sdsu.util.SortedList;

class FilterManagerFrame
extends MuffinFrame
implements ActionListener,
ItemListener,
WindowListener,
ConfigurationListener {
    FilterManager manager;
    BigList knownFiltersList = null;
    BigList enabledFiltersList = null;
    Choice configurationChoice = null;

    public void configurationChanged(String string) {
        this.updateKnownFiltersList();
        this.updateEnabledFiltersList();
        this.updateConfigurationChoice();
    }

    void updateConfigurationChoice() {
        this.configurationChoice.removeAll();
        Enumeration enumeration = this.manager.configs.sortedKeys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.configurationChoice.addItem(string);
        }
        this.configurationChoice.select(this.manager.configs.getCurrent());
    }

    void updateKnownFiltersList() {
        if (this.knownFiltersList.getItemCount() > 0) {
            this.knownFiltersList.removeAll();
        }
        Enumeration enumeration = this.manager.knownFilters.elements();
        SortedList sortedList = new SortedList(StringIgnoreCaseComparer.getInstance());
        while (enumeration.hasMoreElements()) {
            sortedList.addElement((String)enumeration.nextElement());
        }
        enumeration = sortedList.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.knownFiltersList.addItem(string);
        }
    }

    void updateEnabledFiltersList() {
        if (this.enabledFiltersList.getItemCount() > 0) {
            this.enabledFiltersList.removeAll();
        }
        Enumeration enumeration = this.manager.enabledFilters.elements();
        while (enumeration.hasMoreElements()) {
            FilterFactory filterFactory = (FilterFactory)enumeration.nextElement();
            this.enabledFiltersList.addItem(this.manager.shortName(filterFactory.getClass().getName()));
        }
    }

    void hideshow() {
        if (this.isShowing()) {
            ((Component)this).setVisible(false);
        } else {
            this.show();
        }
    }

    void enable(String string) {
        this.manager.enable(string);
        this.updateEnabledFiltersList();
    }

    void disable(int n) {
        this.manager.disable(n);
        this.updateEnabledFiltersList();
    }

    void viewPrefs(String string) {
        Enumeration enumeration = this.manager.enabledFilters.elements();
        while (enumeration.hasMoreElements()) {
            FilterFactory filterFactory = (FilterFactory)enumeration.nextElement();
            if (!string.equals(this.manager.shortName(filterFactory.getClass().getName()))) continue;
            filterFactory.viewPrefs();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.manager.configs.setCurrent(itemEvent.getItem().toString());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        String string = actionEvent.getActionCommand();
        if ("doClose".equals(string)) {
            ((Component)this).setVisible(false);
        } else if ("doSave".equals(string)) {
            this.manager.save();
        } else if ("doEnable".equals(string)) {
            int n2 = this.knownFiltersList.getSelectedIndex();
            if (n2 != -1) {
                this.enable(this.knownFiltersList.getItem(n2));
            }
        } else if ("doDisable".equals(string)) {
            int n3 = this.enabledFiltersList.getSelectedIndex();
            if (n3 != -1) {
                this.disable(n3);
            }
        } else if ("doNewFilter".equals(string)) {
            TextDialog textDialog = new TextDialog((Frame)this, "New filter class name:");
            textDialog.show();
            String string2 = textDialog.getAnswer();
            if (string2 != null && string2.length() > 0) {
                string2.trim();
                this.manager.append(string2);
            }
            textDialog.dispose();
        } else if ("doDelete".equals(string)) {
            int n4 = this.knownFiltersList.getSelectedIndex();
            if (n4 != -1) {
                this.manager.remove(this.knownFiltersList.getItem(n4));
            }
        } else if ("doHelp".equals(string)) {
            int n5 = this.knownFiltersList.getSelectedIndex();
            if (n5 != -1) {
                new HelpFrame(this.knownFiltersList.getItem(n5));
            }
        } else if ("doPrefs".equals(string)) {
            int n6 = this.enabledFiltersList.getSelectedIndex();
            if (n6 != -1) {
                this.viewPrefs(this.enabledFiltersList.getItem(n6));
            }
        } else if ("doUp".equals(string)) {
            int n7 = this.enabledFiltersList.getSelectedIndex();
            if (n7 > 0) {
                Object e = this.manager.enabledFilters.elementAt(n7 - 1);
                Object e2 = this.manager.enabledFilters.elementAt(n7);
                this.manager.enabledFilters.setElementAt(e2, n7 - 1);
                this.manager.enabledFilters.setElementAt(e, n7);
                this.updateEnabledFiltersList();
                this.enabledFiltersList.select(n7 - 1);
            }
        } else if ("doDown".equals(string) && (n = this.enabledFiltersList.getSelectedIndex()) != -1 && n < this.manager.enabledFilters.size() - 1) {
            Object e = this.manager.enabledFilters.elementAt(n + 1);
            Object e3 = this.manager.enabledFilters.elementAt(n);
            this.manager.enabledFilters.setElementAt(e3, n + 1);
            this.manager.enabledFilters.setElementAt(e, n);
            this.updateEnabledFiltersList();
            this.enabledFiltersList.select(n + 1);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    FilterManagerFrame(FilterManager filterManager) {
        super("Muffin: Filters");
        this.manager = filterManager;
        this.setResizable(false);
        this.knownFiltersList = new BigList(10, false);
        this.enabledFiltersList = new BigList(10, false);
        Panel panel = new Panel();
        Label label = new Label("Configuration:");
        panel.add(label);
        this.configurationChoice = new Choice();
        this.updateConfigurationChoice();
        this.configurationChoice.addItemListener(this);
        filterManager.configs.addConfigurationListener(this);
        panel.add(this.configurationChoice);
        this.add("North", panel);
        Panel panel2 = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel2.setLayout(gridBagLayout);
        label = new Label("Known Filters");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel2.add(label);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.insets = new Insets(0, 10, 5, 10);
        gridBagLayout.setConstraints(this.knownFiltersList, gridBagConstraints);
        panel2.add(this.knownFiltersList);
        Button button = new Button("Enable");
        button.setActionCommand("doEnable");
        button.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        panel2.add(button);
        button = new Button("New...");
        button.setActionCommand("doNewFilter");
        button.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        panel2.add(button);
        button = new Button("Delete");
        button.setActionCommand("doDelete");
        button.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        panel2.add(button);
        button = new Button("Help");
        button.setActionCommand("doHelp");
        button.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        panel2.add(button);
        label = new Label("Enabled Filters");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel2.add(label);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.insets = new Insets(0, 10, 5, 10);
        gridBagLayout.setConstraints(this.enabledFiltersList, gridBagConstraints);
        panel2.add(this.enabledFiltersList);
        button = new Button("Preferences...");
        button.setActionCommand("doPrefs");
        button.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        panel2.add(button);
        button = new Button("Move Up");
        button.setActionCommand("doUp");
        button.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        panel2.add(button);
        button = new Button("Move Down");
        button.setActionCommand("doDown");
        button.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        panel2.add(button);
        button = new Button("Disable");
        button.setActionCommand("doDisable");
        button.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        panel2.add(button);
        this.add("Center", panel2);
        Panel panel3 = new Panel();
        button = new Button("Save");
        button.setActionCommand("doSave");
        button.addActionListener(this);
        panel3.add(button);
        button = new Button("Close");
        button.setActionCommand("doClose");
        button.addActionListener(this);
        panel3.add(button);
        this.add("South", panel3);
        this.addWindowListener(this);
        this.updateKnownFiltersList();
        this.updateEnabledFiltersList();
        this.pack();
        ((Component)this).setSize(this.getPreferredSize());
    }
}

