/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TimeZone;
import org.doit.muffin.Main;
import org.doit.muffin.Reply;
import org.doit.muffin.Request;

public class LogFile {
    private static SimpleDateFormat format = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss", Locale.US);
    private static String zoneString;
    private String filename = null;

    public void setLogFile(String string) {
        this.filename = string;
    }

    private static String generateZoneString() {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(15) + calendar.get(16);
        StringBuffer stringBuffer = new StringBuffer();
        if (n < 0) {
            stringBuffer.append("-");
            n = -n;
        }
        int n2 = n / 3600000;
        int n3 = n % 3600000 / 60000;
        if (n2 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n2);
        if (n3 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n3);
        return stringBuffer.toString();
    }

    public synchronized void log(Request request, Reply reply) {
        Object object;
        int n;
        Date date = new Date();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(request.getClient().getInetAddress().getHostAddress());
        stringBuffer.append(" - - ");
        stringBuffer.append("[");
        stringBuffer.append(format.format(date));
        stringBuffer.append(" ");
        stringBuffer.append(zoneString);
        stringBuffer.append("] \"");
        stringBuffer.append(request.getRequest());
        stringBuffer.append("\" ");
        stringBuffer.append(reply.getStatusCode());
        stringBuffer.append(" ");
        try {
            n = Integer.parseInt(reply.getHeaderField("Content-length"));
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        stringBuffer.append(n);
        stringBuffer.append("\n");
        if (!Main.getOptions().getBoolean("muffin.dontLogFilters")) {
            object = request.getLogHeaders();
            while (object != null && object.hasMoreElements()) {
                String string = (String)object.nextElement();
                stringBuffer.append("[");
                stringBuffer.append(string);
                stringBuffer.append("]\n");
                Enumeration enumeration = request.getLogEntries(string);
                while (enumeration.hasMoreElements()) {
                    stringBuffer.append("* ");
                    stringBuffer.append(enumeration.nextElement().toString());
                    stringBuffer.append("\n");
                }
            }
        }
        try {
            object = new FileOutputStream(this.filename, true);
            ((FileOutputStream)object).write(stringBuffer.toString().getBytes());
            ((FileOutputStream)object).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public LogFile(String string) {
        this.setLogFile(string);
    }

    static {
        format.setTimeZone(TimeZone.getDefault());
        zoneString = LogFile.generateZoneString();
    }
}

