/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import org.doit.muffin.Filter;
import org.doit.muffin.FilterFactory;
import org.doit.muffin.FilterManager;
import org.doit.muffin.MessageArea;
import org.doit.muffin.Prefs;
import org.doit.muffin.Request;
import org.doit.muffin.filter.AnimationKillerFilter;
import org.doit.muffin.filter.AnimationKillerFrame;

public class AnimationKiller
implements FilterFactory {
    FilterManager manager;
    Prefs prefs;
    AnimationKillerFrame frame = null;
    MessageArea messages = null;

    public void setManager(FilterManager filterManager) {
        this.manager = filterManager;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
        boolean bl = prefs.getOverride();
        prefs.setOverride(false);
        prefs.putInteger("AnimationKiller.maxLoops", 1);
        prefs.putBoolean("AnimationKiller.break", false);
        prefs.setOverride(bl);
        this.messages = new MessageArea();
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void viewPrefs() {
        if (this.frame == null) {
            this.frame = new AnimationKillerFrame(this.prefs, this);
        }
        this.frame.setVisible(true);
    }

    public Filter createFilter() {
        AnimationKillerFilter animationKillerFilter = new AnimationKillerFilter(this);
        animationKillerFilter.setPrefs(this.prefs);
        return animationKillerFilter;
    }

    public void shutdown() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    void save() {
        this.manager.save(this);
    }

    void report(Request request, String string) {
        request.addLogEntry("AnimationKiller", string);
        this.messages.append(string + "\n");
    }
}

