/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import org.doit.muffin.Filter;
import org.doit.muffin.FilterFactory;
import org.doit.muffin.FilterManager;
import org.doit.muffin.MessageArea;
import org.doit.muffin.Prefs;
import org.doit.muffin.Request;
import org.doit.muffin.filter.CookieMonsterFilter;
import org.doit.muffin.filter.CookieMonsterFrame;

public class CookieMonster
implements FilterFactory {
    FilterManager manager;
    Prefs prefs;
    CookieMonsterFrame frame = null;
    MessageArea messages = null;

    public void setManager(FilterManager filterManager) {
        this.manager = filterManager;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
        boolean bl = prefs.getOverride();
        prefs.setOverride(false);
        prefs.putBoolean("CookieMonster.eatRequestCookies", true);
        prefs.putBoolean("CookieMonster.eatReplyCookies", true);
        prefs.setOverride(bl);
        this.messages = new MessageArea();
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void viewPrefs() {
        if (this.frame == null) {
            this.frame = new CookieMonsterFrame(this.prefs, this);
        }
        this.frame.setVisible(true);
    }

    public Filter createFilter() {
        CookieMonsterFilter cookieMonsterFilter = new CookieMonsterFilter(this);
        cookieMonsterFilter.setPrefs(this.prefs);
        return cookieMonsterFilter;
    }

    public void shutdown() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    void save() {
        this.manager.save(this);
    }

    void report(Request request, String string) {
        request.addLogEntry("CookieMonster", string);
        this.messages.append(string + "\n");
    }
}

