/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.doit.muffin.Filter;
import org.doit.muffin.FilterFactory;
import org.doit.muffin.FilterManager;
import org.doit.muffin.MessageArea;
import org.doit.muffin.Prefs;
import org.doit.muffin.Reply;
import org.doit.muffin.Request;
import org.doit.muffin.filter.TranslateFilter;
import org.doit.muffin.filter.TranslateFrame;

public class Translate
implements FilterFactory {
    FilterManager manager;
    Prefs prefs;
    TranslateFrame frame = null;
    MessageArea messages = null;
    Vector passRulesIn = null;
    Vector passRulesOut = null;
    Vector reverseRulesIn = null;
    Vector reverseRulesOut = null;

    public void setManager(FilterManager filterManager) {
        this.manager = filterManager;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
        boolean bl = prefs.getOverride();
        prefs.setOverride(false);
        String string = prefs.getUserFile("translate");
        prefs.putString("Translate.rules", string);
        prefs.setOverride(bl);
        this.messages = new MessageArea();
        this.load();
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void viewPrefs() {
        if (this.frame == null) {
            this.frame = new TranslateFrame(this.prefs, this);
        }
        this.frame.setVisible(true);
    }

    public Filter createFilter() {
        TranslateFilter translateFilter = new TranslateFilter(this);
        translateFilter.setPrefs(this.prefs);
        return translateFilter;
    }

    public void shutdown() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    void save() {
        this.manager.save(this);
    }

    Request translate(Request request) {
        RE rE = null;
        REMatch rEMatch = null;
        Enumeration enumeration = this.passRulesIn.elements();
        String string = request.getURL();
        int n = 0;
        while (rEMatch == null && enumeration.hasMoreElements()) {
            rE = (RE)enumeration.nextElement();
            rEMatch = rE.getMatch(string);
            ++n;
        }
        if (rEMatch != null) {
            String string2 = (String)this.passRulesOut.elementAt(n - 1);
            String string3 = rEMatch.substituteInto(string2);
            this.report(request, "PASS RULE #" + n + ": " + string + " -> " + string3);
            request.setURL(string3);
        }
        return request;
    }

    Reply translate(Reply reply) {
        RE rE = null;
        REMatch rEMatch = null;
        Enumeration enumeration = this.reverseRulesIn.elements();
        String string = reply.getHeaderField("Location");
        int n = 0;
        while (rEMatch == null && enumeration.hasMoreElements()) {
            rE = (RE)enumeration.nextElement();
            rEMatch = rE.getMatch(string);
            ++n;
        }
        if (rEMatch != null) {
            String string2 = (String)this.reverseRulesOut.elementAt(n - 1);
            String string3 = rEMatch.substituteInto(string2);
            this.report(reply, "PASS RULE #" + n + ": " + string + " -> " + string3);
            reply.setHeaderField("Location", string3);
        }
        return reply;
    }

    void load() {
        String string = this.prefs.getUserFile(this.prefs.getString("Translate.rules"));
        try {
            this.load(new FileReader(new File(string)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void load(Reader reader) {
        this.passRulesIn = new Vector();
        this.passRulesOut = new Vector();
        this.reverseRulesIn = new Vector();
        this.reverseRulesOut = new Vector();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(reader);
            RE rE = new RE("^[# \t\n]");
            while ((string = bufferedReader.readLine()) != null) {
                if (rE.getMatch(string) != null) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
                try {
                    String string2 = stringTokenizer.nextToken();
                    if (string2.equalsIgnoreCase("PASS")) {
                        this.passRulesIn.addElement(new RE(stringTokenizer.nextToken()));
                        this.passRulesOut.addElement(stringTokenizer.nextToken());
                        continue;
                    }
                    this.reverseRulesIn.addElement(new RE(stringTokenizer.nextToken()));
                    this.reverseRulesOut.addElement(stringTokenizer.nextToken());
                }
                catch (REException rEException) {
                    System.out.println("REException: " + rEException);
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void report(Request request, String string) {
        request.addLogEntry("Translate", string);
        this.messages.append(string + "\n");
    }

    void report(Reply reply, String string) {
        this.messages.append(string + "\n");
    }
}

