/*
 * Decompiled with CFR 0.152.
 */
package org.doit.util;

import java.util.Enumeration;
import java.util.Vector;
import org.doit.util.Cleanable;
import org.doit.util.ReusableThread;

public class ThreadPool
implements Cleanable {
    private String name;
    private Vector pool = new Vector();

    public synchronized ReusableThread get() {
        ReusableThread reusableThread = null;
        if (this.pool.size() > 0) {
            reusableThread = (ReusableThread)this.pool.firstElement();
            this.pool.removeElement(reusableThread);
        }
        if (reusableThread == null) {
            reusableThread = new ReusableThread(this);
            reusableThread.start();
        }
        return reusableThread;
    }

    public synchronized void put(ReusableThread reusableThread) {
        this.pool.addElement(reusableThread);
    }

    public synchronized void clean() {
        long l = System.currentTimeMillis();
        Enumeration enumeration = this.pool.elements();
        while (enumeration.hasMoreElements()) {
            ReusableThread reusableThread = (ReusableThread)enumeration.nextElement();
            if (l - reusableThread.getLastRunTime() < 30000L) continue;
            reusableThread.terminate();
            this.pool.removeElement(reusableThread);
        }
    }

    public ThreadPool(String string) {
        this.name = string;
    }
}

