/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xbill.DNS.Name;

public class FindServer {
    private static String[] server = null;
    private static Name[] search = null;
    private static boolean probed = false;

    private static void findProperty() {
        String string;
        Vector<String> vector = null;
        int n = 1;
        while (n <= 5) {
            string = System.getProperty("dns.server" + n);
            if (string == null) break;
            if (vector == null) {
                vector = new Vector<String>();
            }
            vector.addElement(string);
            ++n;
        }
        if (vector != null) {
            server = new String[vector.size()];
            n = 0;
            while (n < vector.size()) {
                FindServer.server[n] = (String)vector.elementAt(n);
                ++n;
            }
        }
        vector = null;
        n = 1;
        while (n <= 5) {
            string = System.getProperty("dns.search" + n);
            if (string == null) break;
            if (vector == null) {
                vector = new Vector();
            }
            vector.addElement(string);
            ++n;
        }
        if (vector != null) {
            search = new Name[vector.size()];
            n = 0;
            while (n < vector.size()) {
                FindServer.search[n] = new Name((String)vector.elementAt(n));
                ++n;
            }
        }
    }

    private static void findUnix() {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream("/etc/resolv.conf");
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        Vector<String> vector = null;
        Vector<String> vector2 = null;
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                String string2;
                StringTokenizer stringTokenizer;
                if (string.startsWith("nameserver")) {
                    if (vector == null) {
                        vector = new Vector<String>();
                    }
                    stringTokenizer = new StringTokenizer(string);
                    stringTokenizer.nextToken();
                    vector.addElement(stringTokenizer.nextToken());
                    continue;
                }
                if (string.startsWith("domain")) {
                    if (vector2 == null) {
                        vector2 = new Vector<String>();
                    }
                    stringTokenizer = new StringTokenizer(string);
                    stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    if (vector2.contains(string2)) continue;
                    vector2.addElement(string2);
                    continue;
                }
                if (!string.startsWith("search")) continue;
                if (vector2 == null) {
                    vector2 = new Vector();
                }
                stringTokenizer = new StringTokenizer(string);
                stringTokenizer.nextToken();
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (vector2.contains(string2)) continue;
                    vector2.addElement(string2);
                }
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (server == null && vector != null) {
            server = new String[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                FindServer.server[n] = (String)vector.elementAt(n);
                ++n;
            }
        }
        if (search == null && vector2 != null) {
            search = new Name[vector2.size()];
            int n = 0;
            while (n < vector2.size()) {
                FindServer.search[n] = new Name((String)vector2.elementAt(n));
                ++n;
            }
        }
    }

    private static synchronized void probe() {
        if (probed) {
            return;
        }
        probed = true;
        FindServer.findProperty();
        if (server == null || search == null) {
            FindServer.findUnix();
        }
        if (search == null) {
            search = new Name[1];
        } else {
            Name[] nameArray = search;
            search = new Name[nameArray.length + 1];
            System.arraycopy(nameArray, 0, search, 0, nameArray.length);
        }
        FindServer.search[FindServer.search.length - 1] = Name.root;
    }

    public static String[] servers() {
        FindServer.probe();
        return server;
    }

    public static String server() {
        String[] stringArray = FindServer.servers();
        if (stringArray == null) {
            return null;
        }
        return stringArray[0];
    }

    public static Name[] searchPath() {
        FindServer.probe();
        return search;
    }

    private FindServer() {
    }
}

