/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class MX_KXRecord
extends Record {
    private short priority;
    private Name target;

    public String toString() {
        StringBuffer stringBuffer = this.toStringNoData();
        if (this.target != null) {
            stringBuffer.append(this.priority);
            stringBuffer.append(" ");
            stringBuffer.append(this.target);
        }
        return stringBuffer.toString();
    }

    public Name getTarget() {
        return this.target;
    }

    public short getPriority() {
        return this.priority;
    }

    void rrToWire(DataByteOutputStream dataByteOutputStream, Compression compression) throws IOException {
        if (this.target == null) {
            return;
        }
        dataByteOutputStream.writeShort(this.priority);
        this.target.toWire(dataByteOutputStream, null);
    }

    void rrToWireCanonical(DataByteOutputStream dataByteOutputStream) throws IOException {
        if (this.target == null) {
            return;
        }
        dataByteOutputStream.writeShort(this.priority);
        this.target.toWireCanonical(dataByteOutputStream);
    }

    protected MX_KXRecord() {
    }

    public MX_KXRecord(Name name, short s, short s2, int n, int n2, Name name2) {
        super(name, s, s2, n);
        this.priority = (short)n2;
        this.target = name2;
    }

    protected MX_KXRecord(Name name, short s, short s2, int n, int n2, DataByteInputStream dataByteInputStream, Compression compression) throws IOException {
        super(name, s, s2, n);
        if (dataByteInputStream == null) {
            return;
        }
        this.priority = (short)dataByteInputStream.readUnsignedShort();
        this.target = new Name(dataByteInputStream, compression);
    }

    protected MX_KXRecord(Name name, short s, short s2, int n, MyStringTokenizer myStringTokenizer, Name name2) throws IOException {
        super(name, s, s2, n);
        this.priority = Short.parseShort(myStringTokenizer.nextToken());
        this.target = new Name(myStringTokenizer.nextToken(), name2);
    }
}

