/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.BitSet;
import java.util.Vector;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Type;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class NXTRecord
extends Record {
    private Name next;
    private BitSet bitmap;

    public String toString() {
        StringBuffer stringBuffer = this.toStringNoData();
        if (this.next != null) {
            stringBuffer.append(this.next);
            int n = 0;
            while (n < this.bitmap.size()) {
                if (this.bitmap.get(n)) {
                    stringBuffer.append(" ");
                    stringBuffer.append(Type.string(n));
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public Name getNext() {
        return this.next;
    }

    public BitSet getBitmap() {
        return this.bitmap;
    }

    void rrToWire(DataByteOutputStream dataByteOutputStream, Compression compression) throws IOException {
        if (this.next == null) {
            return;
        }
        this.next.toWire(dataByteOutputStream, null);
        int n = 0;
        int n2 = 0;
        while (n < this.bitmap.size()) {
            n2 |= this.bitmap.get(n) ? 1 << 7 - n % 8 : 0;
            if (n % 8 == 7 || n == this.bitmap.size() - 1) {
                dataByteOutputStream.writeByte(n2);
                n2 = 0;
            }
            ++n;
        }
    }

    void rrToWireCanonical(DataByteOutputStream dataByteOutputStream) throws IOException {
        if (this.next == null) {
            return;
        }
        this.next.toWireCanonical(dataByteOutputStream);
        int n = 0;
        int n2 = 0;
        while (n < this.bitmap.size()) {
            n2 |= this.bitmap.get(n) ? 1 << 7 - n % 8 : 0;
            if (n % 8 == 7 || n == this.bitmap.size() - 1) {
                dataByteOutputStream.writeByte(n2);
                n2 = 0;
            }
            ++n;
        }
    }

    private NXTRecord() {
    }

    public NXTRecord(Name name, short s, int n, Name name2, BitSet bitSet) {
        super(name, (short)30, s, n);
        this.next = name2;
        this.bitmap = bitSet;
    }

    NXTRecord(Name name, short s, int n, int n2, DataByteInputStream dataByteInputStream, Compression compression) throws IOException {
        super(name, (short)30, s, n);
        if (dataByteInputStream == null) {
            return;
        }
        int n3 = dataByteInputStream.getPos();
        this.next = new Name(dataByteInputStream, compression);
        this.bitmap = new BitSet();
        int n4 = n2 - (dataByteInputStream.getPos() - n3);
        int n5 = 0;
        while (n5 < n4) {
            int n6 = dataByteInputStream.readUnsignedByte();
            int n7 = 0;
            while (n7 < 8) {
                if ((n6 & 1 << 7 - n7) != 0) {
                    this.bitmap.set(n5 * 8 + n7);
                }
                ++n7;
            }
            ++n5;
        }
    }

    NXTRecord(Name name, short s, int n, MyStringTokenizer myStringTokenizer, Name name2) throws IOException {
        super(name, (short)30, s, n);
        Vector vector = new Vector();
        this.next = new Name(myStringTokenizer.nextToken(), name2);
        this.bitmap = new BitSet();
        while (myStringTokenizer.hasMoreTokens()) {
            short s2 = Type.value(myStringTokenizer.nextToken());
            if (s2 <= 0) continue;
            this.bitmap.set(s2);
        }
    }
}

