/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.xbill.DNS.utils.md5;

public class hmacSigner {
    private static final byte IPAD = 54;
    private static final byte OPAD = 92;
    private static final byte PADLEN = 64;
    private byte[] ipad;
    private byte[] opad;
    private ByteArrayOutputStream bytes;

    private static void printByteString(String string, byte[] byArray, int n, int n2) {
        System.out.print(n2 + " bytes (" + string + "): ");
        int n3 = n;
        while (n3 < n + n2) {
            System.out.print(Integer.toHexString(byArray[n3] & 0xFF) + " ");
            ++n3;
        }
        System.out.println();
    }

    public void addData(byte[] byArray, int n, int n2) {
        if (n2 <= 0 || n + n2 >= byArray.length) {
            return;
        }
        this.bytes.write(byArray, n, n2);
    }

    public void addData(byte[] byArray) {
        try {
            this.bytes.write(byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public byte[] sign() {
        byte[] byArray = md5.compute(this.bytes.toByteArray());
        this.bytes = new ByteArrayOutputStream();
        try {
            this.bytes.write(this.opad);
            this.bytes.write(byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] byArray2 = md5.compute(this.bytes.toByteArray());
        return byArray2;
    }

    public boolean verify(byte[] byArray) {
        return hmacSigner.byteArrayCompare(byArray, this.sign());
    }

    public void clear() {
        this.bytes = new ByteArrayOutputStream();
        try {
            this.bytes.write(this.ipad);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean byteArrayCompare(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public hmacSigner(byte[] byArray) {
        if (byArray.length > 64) {
            byArray = md5.compute(byArray);
        }
        this.ipad = new byte[64];
        this.opad = new byte[64];
        int n = 0;
        while (n < byArray.length) {
            this.ipad[n] = (byte)(byArray[n] ^ 0x36);
            this.opad[n] = (byte)(byArray[n] ^ 0x5C);
            ++n;
        }
        while (n < 64) {
            this.ipad[n] = 54;
            this.opad[n] = 92;
            ++n;
        }
        this.bytes = new ByteArrayOutputStream();
        try {
            this.bytes.write(this.ipad);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

