/*
 * Decompiled with CFR 0.152.
 */
package org.doit.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FixedBufferedInputStream
extends FilterInputStream {
    private final int BUFSIZE;
    private int maxBytes = 0;
    private int byteCount = 0;
    private byte[] bytes = null;
    private int blength = 0;
    private int index = 0;
    private boolean eof = false;

    public int read() throws IOException {
        int n;
        if (this.eof) {
            return -1;
        }
        if (this.bytes == null) {
            n = this.maxBytes > 0 ? Math.min(this.maxBytes - this.byteCount, 8192) : 8192;
            this.bytes = new byte[n];
            n = this.read(this.bytes);
            if (n <= 0) {
                this.eof = true;
                return -1;
            }
            this.blength = n;
            this.byteCount += n;
        }
        n = this.bytes[this.index++];
        if (this.index == this.blength) {
            this.bytes = null;
            this.index = 0;
            this.blength = 0;
            if (this.byteCount == this.maxBytes) {
                this.eof = true;
            }
        }
        return n & 0xFF;
    }

    public FixedBufferedInputStream(InputStream inputStream, int n) {
        super(inputStream);
        this.BUFSIZE = 8192;
        this.maxBytes = n;
    }
}

