/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.zip.GZIPInputStream;
import org.doit.io.ByteArray;
import org.doit.io.HtmlObjectStream;
import org.doit.io.InputObjectStream;
import org.doit.io.OutputObjectStream;
import org.doit.io.SourceObjectStream;
import org.doit.muffin.Client;
import org.doit.muffin.Connection;
import org.doit.muffin.ContentFilter;
import org.doit.muffin.Copy;
import org.doit.muffin.Filter;
import org.doit.muffin.FilterException;
import org.doit.muffin.FilterManager;
import org.doit.muffin.Http;
import org.doit.muffin.HttpConnection;
import org.doit.muffin.HttpError;
import org.doit.muffin.HttpFilter;
import org.doit.muffin.HttpRelay;
import org.doit.muffin.Httpd;
import org.doit.muffin.Https;
import org.doit.muffin.LogFile;
import org.doit.muffin.Main;
import org.doit.muffin.Monitor;
import org.doit.muffin.Options;
import org.doit.muffin.RedirectFilter;
import org.doit.muffin.Reply;
import org.doit.muffin.ReplyFilter;
import org.doit.muffin.Request;
import org.doit.muffin.RequestFilter;
import org.doit.muffin.RetryRequestException;
import org.doit.util.ReusableThread;

class Handler
implements Runnable {
    static final boolean DEBUG = false;
    Monitor monitor = null;
    FilterManager manager = null;
    Options options = null;
    Client client = null;
    Socket socket = null;
    Request request = null;
    Reply reply = null;
    HttpRelay http = null;
    int currentLength = -1;
    int contentLength = -1;
    Filter[] filterList;
    long idle = 0L;
    double bytesPerSecond = 0.0;

    synchronized void close() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        if (this.http != null) {
            this.http.close();
            this.http = null;
        }
    }

    void flush() {
        if (this.client != null) {
            try {
                this.client.getOutputStream().flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void run() {
        boolean bl = false;
        Exception exception = null;
        Thread.currentThread().setName("Handler(" + this.socket.getInetAddress().getHostAddress() + ")");
        try {
            this.client = new Client(this.socket);
            this.client.setTimeout(this.options.getInteger("muffin.readTimeout"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        try {
            this.monitor.register(this);
            do {
                LogFile logFile;
                this.request = null;
                this.reply = null;
                this.filterList = null;
                this.idle = System.currentTimeMillis();
                this.monitor.update(this);
                try {
                    this.request = this.client.read();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    break;
                }
                this.idle = 0L;
                this.monitor.update(this);
                try {
                    bl = this.processRequest();
                }
                catch (IOException iOException) {
                    exception = iOException;
                    bl = false;
                }
                catch (FilterException filterException) {
                    exception = filterException;
                    bl = false;
                }
                if (this.request == null || this.reply == null) continue;
                if (this.reply != null && this.currentLength > 0) {
                    this.reply.setHeaderField("Content-length", this.currentLength);
                }
                if ((logFile = Main.getLogFile()) == null) continue;
                logFile.log(this.request, this.reply);
            } while (bl);
        }
        catch (Throwable throwable) {
            Object var4_10 = null;
            this.monitor.unregister(this);
            throw throwable;
        }
        Object var4_9 = null;
        this.monitor.unregister(this);
        if (exception != null && exception.getMessage().indexOf("Broken pipe") == -1) {
            if (this.client != null && this.request != null) {
                this.error(this.client.getOutputStream(), exception, this.request);
            }
            if (!(exception instanceof FilterException)) {
                exception.printStackTrace();
            }
        }
        this.close();
    }

    boolean processRequest() throws IOException, FilterException {
        boolean bl = false;
        while (this.reply == null) {
            Object object;
            boolean bl2 = false;
            boolean bl3 = false;
            this.filterList = this.manager.createFilters(this.request.getURL());
            if (this.request.getCommand().equals("CONNECT")) {
                bl2 = true;
            } else if (this.request.getURL().startsWith("/")) {
                this.request.setURL("http://" + Main.getMuffinHost() + ":" + this.options.getString("muffin.port") + this.request.getURL());
            } else {
                if (this.request.getURL().startsWith("https://")) {
                    System.out.println("Netscape keep-alive bug: " + this.request.getURL());
                    return false;
                }
                if (!this.request.getURL().startsWith("http://")) {
                    System.out.println("Unknown URL: " + this.request.getURL());
                    return false;
                }
            }
            if (this.options.getBoolean("muffin.proxyKeepAlive")) {
                boolean bl4 = bl = this.request.containsHeaderField("Proxy-Connection") && this.request.getHeaderField("Proxy-Connection").equals("Keep-Alive");
            }
            if (!this.options.getBoolean("muffin.passthru")) {
                object = this.redirect(this.request);
                if (object != null) {
                    Reply reply = Reply.createRedirect((String)object);
                    this.client.write(reply);
                    return bl;
                }
                this.filter(this.request);
            }
            this.http = this.createHttpFilter(this.request);
            if (this.http == null) {
                this.http = bl2 ? this.createHttpsRelay() : this.createHttpRelay();
            }
            try {
                this.http.sendRequest(this.request);
                if (this.http instanceof Http) {
                    ((Http)this.http).setTimeout(this.options.getInteger("muffin.readTimeout"));
                }
                this.reply = this.http.recvReply(this.request);
            }
            catch (RetryRequestException retryRequestException) {
                this.http.close();
                this.http = null;
                continue;
            }
            if (this.reply.headerCount() == 0 && (((String)(object = this.request.getURL())).endsWith("/") || ((String)object).endsWith(".html") || ((String)object).endsWith(".htm"))) {
                this.reply.setHeaderField("Content-type", "text/html");
            }
            this.monitor.update(this);
            if (!this.options.getBoolean("muffin.passthru")) {
                if (!this.options.getBoolean("muffin.dontUncompress") && "text/html".equals(this.reply.getHeaderField("Content-type")) && (object = this.reply.getHeaderField("Content-Encoding")) != null && ((String)object).indexOf("gzip") != -1) {
                    this.reply.removeHeaderField("Content-Encoding");
                    this.reply.removeHeaderField("Content-length");
                    bl3 = true;
                }
                this.filter(this.reply);
            }
            this.reply.removeHeaderField("Proxy-Connection");
            if (bl && this.reply.containsHeaderField("Content-length")) {
                this.reply.setHeaderField("Proxy-Connection", "Keep-Alive");
            } else {
                bl = false;
            }
            this.currentLength = -1;
            this.contentLength = -1;
            try {
                this.contentLength = Integer.parseInt(this.reply.getHeaderField("Content-length"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.monitor.update(this);
            if (bl2) {
                object = (Https)this.http;
                int n = this.options.getInteger("muffin.readTimeout");
                this.client.write(this.reply);
                try {
                    this.client.setTimeout(n);
                    ((Connection)object).setTimeout(n);
                    Copy copy = new Copy(this.client.getInputStream(), ((HttpConnection)object).getOutputStream());
                    ReusableThread reusableThread = Main.getThread();
                    reusableThread.setRunnable(copy);
                    this.flushCopy(((HttpConnection)object).getInputStream(), this.client.getOutputStream(), -1, true);
                    this.client.close();
                }
                catch (InterruptedIOException interruptedIOException) {}
            } else if (this.reply.hasContent()) {
                try {
                    this.processContent(bl3);
                }
                catch (IOException iOException) {
                    if (this.http instanceof Http) {
                        ((Http)this.http).reallyClose();
                    } else {
                        this.http.close();
                    }
                    this.http = null;
                    this.client.close();
                    this.client = null;
                    throw iOException;
                }
                if (this.contentLength == 0) {
                    this.client.close();
                }
            } else {
                this.client.write(this.reply);
            }
            this.http.close();
        }
        return bl;
    }

    HttpRelay createHttpsRelay() throws IOException {
        Https https = this.options.useHttpsProxy() ? new Https(this.options.getString("muffin.httpsProxyHost"), this.options.getInteger("muffin.httpsProxyPort"), true) : new Https(this.request.getHost(), this.request.getPort());
        return https;
    }

    HttpRelay createHttpRelay() throws IOException {
        HttpConnection httpConnection = Httpd.sendme(this.request) ? new Httpd(this.socket) : (this.options.useHttpProxy() ? Http.open(this.options.getString("muffin.httpProxyHost"), this.options.getInteger("muffin.httpProxyPort"), true) : Http.open(this.request.getHost(), this.request.getPort()));
        return httpConnection;
    }

    HttpRelay createHttpFilter(Request request) {
        int n = 0;
        while (n < this.filterList.length) {
            HttpFilter httpFilter;
            if (this.filterList[n] instanceof HttpFilter && (httpFilter = (HttpFilter)this.filterList[n]).wantRequest(request)) {
                return httpFilter;
            }
            ++n;
        }
        return null;
    }

    InputStream readChunkedTransfer(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        int n = 0;
        this.contentLength = 0;
        while ((n = this.reply.getChunkSize(inputStream)) > 0) {
            this.contentLength += n;
            this.copy(inputStream, byteArrayOutputStream, n, true);
            this.reply.readLine(inputStream);
        }
        this.reply.getChunkedFooter(inputStream);
        this.reply.removeHeaderField("Transfer-Encoding");
        this.reply.setHeaderField("Content-length", this.contentLength);
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    void processContent(boolean bl) throws IOException {
        InputStream inputStream;
        boolean bl2 = false;
        if (this.reply.containsHeaderField("Transfer-Encoding") && this.reply.getTransferEncoding().equals("chunked")) {
            inputStream = this.readChunkedTransfer(this.reply.getContent());
            bl2 = true;
        } else {
            inputStream = this.reply.getContent();
        }
        if (inputStream == null) {
            System.out.println("No inputstream");
            return;
        }
        if (bl) {
            inputStream = new GZIPInputStream(inputStream);
        }
        if (this.options.getBoolean("muffin.passthru")) {
            this.client.write(this.reply);
            this.copy(inputStream, this.client.getOutputStream(), this.contentLength, true);
        } else if (this.contentNeedsFiltration()) {
            if (this.options.getBoolean("muffin.proxyKeepAlive")) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
                this.filter(inputStream, byteArrayOutputStream, this.contentLength, !bl2);
                this.reply.setHeaderField("Content-length", byteArrayOutputStream.size());
                this.client.write(this.reply);
                this.copy(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), this.client.getOutputStream(), byteArrayOutputStream.size(), false);
            } else {
                this.reply.removeHeaderField("Content-length");
                this.client.write(this.reply);
                this.filter(inputStream, this.client.getOutputStream(), -1, !bl2);
            }
        } else {
            this.client.write(this.reply);
            this.copy(inputStream, this.client.getOutputStream(), this.contentLength, true);
        }
    }

    String redirect(Request request) {
        int n = 0;
        while (n < this.filterList.length) {
            RedirectFilter redirectFilter;
            if (this.filterList[n] instanceof RedirectFilter && (redirectFilter = (RedirectFilter)this.filterList[n]).needsRedirection(request)) {
                String string = redirectFilter.redirect(request);
                return string;
            }
            ++n;
        }
        return null;
    }

    void filter(Reply reply) throws FilterException {
        int n = 0;
        while (n < this.filterList.length) {
            if (this.filterList[n] instanceof ReplyFilter) {
                ((ReplyFilter)this.filterList[n]).filter(reply);
            }
            ++n;
        }
    }

    void filter(Request request) throws FilterException {
        int n = 0;
        while (n < this.filterList.length) {
            if (this.filterList[n] instanceof RequestFilter) {
                ((RequestFilter)this.filterList[n]).filter(request);
            }
            ++n;
        }
    }

    boolean contentNeedsFiltration() {
        int n = 0;
        while (n < this.filterList.length) {
            ContentFilter contentFilter;
            if (this.filterList[n] instanceof ContentFilter && (contentFilter = (ContentFilter)this.filterList[n]).needsFiltration(this.request, this.reply)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void filter(InputStream inputStream, OutputStream outputStream, int n, boolean bl) throws IOException {
        InputObjectStream inputObjectStream = new InputObjectStream();
        SourceObjectStream sourceObjectStream = this.reply.containsHeaderField("Content-type") && this.reply.getContentType().equals("text/html") ? new HtmlObjectStream(inputObjectStream) : new SourceObjectStream(inputObjectStream);
        int n2 = 0;
        while (n2 < this.filterList.length) {
            ContentFilter contentFilter;
            if (this.filterList[n2] instanceof ContentFilter && (contentFilter = (ContentFilter)this.filterList[n2]).needsFiltration(this.request, this.reply)) {
                OutputObjectStream outputObjectStream = new OutputObjectStream();
                InputObjectStream inputObjectStream2 = new InputObjectStream(outputObjectStream);
                contentFilter.setInputObjectStream(inputObjectStream);
                contentFilter.setOutputObjectStream(outputObjectStream);
                ReusableThread reusableThread = Main.getThread();
                reusableThread.setPriority(1);
                reusableThread.setRunnable(contentFilter);
                inputObjectStream = inputObjectStream2;
            }
            ++n2;
        }
        sourceObjectStream.setSourceInputStream(inputStream);
        sourceObjectStream.setSourceLength(n);
        ReusableThread reusableThread = Main.getThread();
        reusableThread.setName("ObjectStream Source(" + this.socket.getInetAddress().getHostAddress() + ")");
        reusableThread.setPriority(1);
        reusableThread.setRunnable(sourceObjectStream);
        Thread.currentThread().setPriority(1);
        this.copy(inputObjectStream, outputStream, bl);
    }

    int getTotalBytes() {
        return this.contentLength > 0 ? this.contentLength : 0;
    }

    int getCurrentBytes() {
        return this.currentLength > 0 ? this.currentLength : 0;
    }

    void error(OutputStream outputStream, Exception exception, Request request) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("While trying to retrieve the URL: <a href=\"" + request.getURL() + "\">" + request.getURL() + "</a>\r\n");
        stringBuffer.append("<p>\r\nThe following error was encountered:\r\n<p>\r\n");
        stringBuffer.append("<ul><li>" + exception.toString() + "</ul>\r\n");
        String string = new HttpError(this.options, 400, stringBuffer.toString()).toString();
        try {
            outputStream.write(string.getBytes(), 0, string.length());
            outputStream.flush();
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    void copy(InputStream inputStream, OutputStream outputStream, int n, boolean bl) throws IOException {
        if (n == 0) {
            return;
        }
        byte[] byArray = new byte[8192];
        long l = System.currentTimeMillis();
        long l2 = 0L;
        long l3 = l;
        this.bytesPerSecond = 0.0;
        if (bl) {
            this.currentLength = 0;
        }
        while (true) {
            int n2 = n > 0 ? Math.min(n, byArray.length) : byArray.length;
            if ((n2 = inputStream.read(byArray, 0, n2)) < 0) break;
            outputStream.write(byArray, 0, n2);
            if (bl) {
                this.currentLength += n2;
                this.monitor.update(this);
            }
            l2 = System.currentTimeMillis();
            this.bytesPerSecond = (double)this.currentLength / ((double)(l2 - l) / 1000.0);
            if (l2 - l3 > 1000L) {
                outputStream.flush();
            }
            if (n != -1 && (n -= n2) == 0) break;
            l3 = l2;
        }
        outputStream.flush();
    }

    void flushCopy(InputStream inputStream, OutputStream outputStream, int n, boolean bl) throws IOException {
        int n2;
        if (n == 0) {
            return;
        }
        byte[] byArray = new byte[8192];
        long l = System.currentTimeMillis();
        this.bytesPerSecond = 0.0;
        if (bl) {
            this.currentLength = 0;
        }
        do {
            n2 = n > 0 ? Math.min(n, byArray.length) : byArray.length;
            if ((n2 = inputStream.read(byArray, 0, n2)) < 0) break;
            outputStream.write(byArray, 0, n2);
            outputStream.flush();
            if (bl) {
                this.currentLength += n2;
                this.monitor.update(this);
            }
            this.bytesPerSecond = (double)this.currentLength / ((double)(System.currentTimeMillis() - l) / 1000.0);
        } while (n == -1 || (n -= n2) != 0);
        outputStream.flush();
    }

    void copy(InputObjectStream inputObjectStream, OutputStream outputStream, boolean bl) throws IOException {
        Object object;
        long l = System.currentTimeMillis();
        long l2 = 0L;
        long l3 = l;
        this.bytesPerSecond = 0.0;
        if (bl) {
            this.currentLength = 0;
        }
        while ((object = inputObjectStream.read()) != null) {
            Object object2;
            if (object instanceof ByteArray) {
                object2 = (ByteArray)object;
                ((ByteArray)object2).writeTo(outputStream);
                this.currentLength += ((ByteArray)object2).length();
            } else if (object instanceof Byte) {
                object2 = (Byte)object;
                outputStream.write(((Byte)object2).byteValue());
                ++this.currentLength;
            } else {
                System.out.println("Unknown object: " + object.toString());
            }
            if (bl) {
                this.monitor.update(this);
                Thread.currentThread();
                Thread.yield();
            }
            l2 = System.currentTimeMillis();
            this.bytesPerSecond = (double)this.currentLength / ((double)(l2 - l) / 1000.0);
            if (l2 - l3 > 1000L) {
                outputStream.flush();
            }
            l3 = l2;
        }
        outputStream.flush();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CLIENT ");
        stringBuffer.append(this.socket.getInetAddress().getHostAddress());
        stringBuffer.append(":");
        stringBuffer.append(this.socket.getPort());
        stringBuffer.append(" - ");
        if (this.request == null) {
            stringBuffer.append("idle " + (double)(System.currentTimeMillis() - this.idle) / 1000.0 + " sec");
        } else {
            if (this.reply != null && this.currentLength > 0) {
                stringBuffer.append("(");
                stringBuffer.append(this.currentLength);
                if (this.contentLength > 0) {
                    stringBuffer.append("/");
                    stringBuffer.append(this.contentLength);
                }
                stringBuffer.append(" ");
                stringBuffer.append((int)this.bytesPerSecond / 1024 + " kB/s");
                stringBuffer.append(") ");
            }
            stringBuffer.append(this.request.getURL());
        }
        return stringBuffer.toString();
    }

    Handler(Monitor monitor, FilterManager filterManager, Options options, Socket socket) {
        this.monitor = monitor;
        this.manager = filterManager;
        this.options = options;
        this.socket = socket;
    }
}

