/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.doit.muffin.LocalFile;
import org.doit.muffin.Prefs;
import org.doit.muffin.UserFile;
import org.doit.util.SortedProperties;

class UserPrefs
extends Prefs {
    String rcfile = "unknown";
    boolean loaded = false;

    void setPrefsFile(String string) {
        this.rcfile = string;
    }

    String getPrefsFile() {
        return this.rcfile;
    }

    void unload() {
        this.clear();
        this.loaded = false;
    }

    void load() {
        if (this.loaded) {
            return;
        }
        UserFile userFile = this.getUserFile(this.rcfile);
        try {
            InputStream inputStream = userFile.getInputStream();
            Properties properties = new Properties();
            properties.load(inputStream);
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.put(string, properties.get(string));
            }
            inputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        this.loaded = true;
    }

    void save() {
        Object object;
        SortedProperties sortedProperties = new SortedProperties();
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            sortedProperties.put(object, this.get(object));
        }
        this.checkUserDirectory();
        try {
            object = this.getUserFile(this.rcfile);
            if (object instanceof LocalFile) {
                OutputStream outputStream = object.getOutputStream();
                sortedProperties.save(outputStream, null);
                outputStream.close();
            } else {
                System.out.println("Can't save to " + object.getName());
            }
        }
        catch (IOException iOException) {
            System.out.println(enumeration);
        }
    }

    UserPrefs() {
    }

    UserPrefs(String string) {
        this.setPrefsFile(string);
    }
}

