/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import gnu.regexp.RE;
import gnu.regexp.REException;
import org.doit.muffin.Filter;
import org.doit.muffin.FilterFactory;
import org.doit.muffin.FilterManager;
import org.doit.muffin.MessageArea;
import org.doit.muffin.Prefs;
import org.doit.muffin.Request;
import org.doit.muffin.filter.NoCodeFilter;
import org.doit.muffin.filter.NoCodeFrame;

public class NoCode
implements FilterFactory {
    FilterManager manager;
    Prefs prefs;
    NoCodeFrame frame = null;
    MessageArea messages = null;
    private RE javaScriptTags = null;
    private RE javaScriptAttrs = null;

    public void setManager(FilterManager filterManager) {
        this.manager = filterManager;
        try {
            this.javaScriptTags = new RE("^(a|input|body|form|area|select|frameset|label|textarea|button|applet|base|basefont|bdo|br|font|frame|head|html|iframe|isindex|meta|param|script|style|title)$");
            this.javaScriptAttrs = new RE("^(onload|onunload|onclick|ondblclick|onmousedown|onmouseup|onmouseover|onmousemove|onmouseout|onfocus|onblur|onkeypress|onkeydown|onkeyup|onsubmit|onreset|onselect|onchange)$");
        }
        catch (REException rEException) {
            rEException.printStackTrace();
        }
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
        boolean bl = prefs.getOverride();
        prefs.setOverride(false);
        prefs.putBoolean("NoCode.noJavaScript", true);
        prefs.putBoolean("NoCode.noVBScript", true);
        prefs.putBoolean("NoCode.noOtherScript", true);
        prefs.putBoolean("NoCode.noEncodedScript", true);
        prefs.putBoolean("NoCode.noEvalInScript", true);
        prefs.putBoolean("NoCode.noJava", false);
        prefs.setOverride(bl);
        this.messages = new MessageArea();
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void viewPrefs() {
        if (this.frame == null) {
            this.frame = new NoCodeFrame(this.prefs, this);
        }
        this.frame.setVisible(true);
    }

    public Filter createFilter() {
        NoCodeFilter noCodeFilter = new NoCodeFilter(this);
        noCodeFilter.setPrefs(this.prefs);
        return noCodeFilter;
    }

    public void shutdown() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    public boolean isJavaScriptTag(String string) {
        return this.javaScriptTags.getMatch(string) != null;
    }

    public boolean isJavaScriptAttr(String string) {
        return this.javaScriptAttrs.getMatch(string) != null;
    }

    void save() {
        this.manager.save(this);
    }

    void report(Request request, String string) {
        request.addLogEntry("NoCode", string);
        this.messages.append(string + "\n");
    }
}

