/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import org.xbill.DNS.utils.StringValueTable;

public final class Flags {
    private static StringValueTable flags = new StringValueTable();
    public static final byte QR = 0;
    public static final byte AA = 5;
    public static final byte TC = 6;
    public static final byte RD = 7;
    public static final byte RA = 8;
    public static final byte AD = 10;
    public static final byte CD = 11;

    public static String string(int n) {
        if (n >= 1 && n <= 4 || n >= 12 && n <= 15) {
            return null;
        }
        String string = flags.getString(n);
        return string != null ? string : new Integer(n).toString();
    }

    public static byte value(String string) {
        byte by = (byte)flags.getValue(string.toLowerCase());
        if (by >= 0) {
            return by;
        }
        try {
            return Byte.parseByte(string);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private Flags() {
    }

    static {
        flags.put2(0, "qr");
        flags.put2(5, "aa");
        flags.put2(6, "tc");
        flags.put2(7, "rd");
        flags.put2(8, "ra");
        flags.put2(10, "ad");
        flags.put2(11, "cd");
    }
}

