/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import org.xbill.DNS.utils.StringValueTable;

public final class Rcode {
    private static StringValueTable rcodes = new StringValueTable();
    public static final byte NOERROR = 0;
    public static final byte FORMERR = 1;
    public static final byte SERVFAIL = 2;
    public static final byte NXDOMAIN = 3;
    public static final byte NOTIMPL = 4;
    public static final byte REFUSED = 5;
    public static final byte YXDOMAIN = 6;
    public static final byte YXRRSET = 7;
    public static final byte NXRRSET = 8;
    public static final byte NOTAUTH = 9;
    public static final byte NOTZONE = 10;
    public static final byte BADSIG = 16;
    public static final byte BADKEY = 17;
    public static final byte BADTIME = 18;

    public static String string(int n) {
        String string = rcodes.getString(n);
        return string != null ? string : new Integer(n).toString();
    }

    public static byte value(String string) {
        byte by = (byte)rcodes.getValue(string.toUpperCase());
        if (by >= 0) {
            return by;
        }
        try {
            return Byte.parseByte(string);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private Rcode() {
    }

    static {
        rcodes.put2(0, "NOERROR");
        rcodes.put2(1, "FORMERR");
        rcodes.put2(2, "SERVFAIL");
        rcodes.put2(3, "NXDOMAIN");
        rcodes.put2(4, "NOTIMPL");
        rcodes.put2(5, "REFUSED");
        rcodes.put2(6, "YXDOMAIN");
        rcodes.put2(7, "YXRRSET");
        rcodes.put2(8, "NXRRSET");
        rcodes.put2(9, "NOTAUTH");
        rcodes.put2(10, "NOTZONE");
        rcodes.put2(16, "BADSIG");
        rcodes.put2(17, "BADKEY");
        rcodes.put2(18, "BADTIME");
    }
}

