/*
 * Decompiled with CFR 0.152.
 */
package sdsu.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringBufferInputStream;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import sdsu.util.ConversionException;
import sdsu.util.OrderedCollection;
import sdsu.util.ReverseListEnumerator;
import sdsu.util.SimpleTokenizer;
import sdsu.util.Stringizable;
import sdsu.util.Stringizer;
import sdsu.util.TokenCharacters;

public class List
implements OrderedCollection,
Stringizable {
    protected Vector internalVector = null;
    private char separatorChar = (char)44;
    private TokenCharacters parseTable = new TokenCharacters(String.valueOf(this.separatorChar));

    public void fromString(String string) throws ConversionException {
        this.load(new StringBufferInputStream(string));
    }

    public void load(InputStream inputStream) throws ConversionException {
        try {
            SimpleTokenizer simpleTokenizer = new SimpleTokenizer(inputStream, this.parseTable);
            while (simpleTokenizer.hasMoreTokens()) {
                this.addElement(simpleTokenizer.nextToken());
            }
        }
        catch (IOException iOException) {
            throw new ConversionException("IO Exception thrown in converting object");
        }
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        Stringizer stringizer = new Stringizer(this.parseTable);
        stringizer.setHeader(string);
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            stringizer.appendToken(enumeration.nextElement(), this.separatorChar);
        }
        return stringizer.toString();
    }

    public Vector toVector() {
        Vector vector = new Vector(this.internalVector.capacity());
        Enumeration enumeration = this.internalVector.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.internalVector.size()];
        this.internalVector.copyInto(objectArray);
        return objectArray;
    }

    public void save(OutputStream outputStream, String string) {
        PrintStream printStream = new PrintStream(outputStream);
        printStream.println(this.toString(string));
        printStream.flush();
    }

    public void setSeparatorChar(char c) {
        this.separatorChar = c;
        this.upDateParseTable();
    }

    public void setTokenCharacters(TokenCharacters tokenCharacters) {
        this.parseTable = tokenCharacters;
        this.upDateParseTable();
    }

    private void upDateParseTable() {
        this.parseTable.setSeparatorChars(String.valueOf(this.separatorChar));
    }

    public final synchronized Enumeration elementsReversed() {
        return new ReverseListEnumerator(this);
    }

    public final synchronized int intAt(int n) {
        Number number = (Number)this.elementAt(n);
        return number.intValue();
    }

    public final synchronized double doubleAt(int n) {
        Number number = (Number)this.elementAt(n);
        return number.doubleValue();
    }

    public final synchronized void addElement(int n) {
        this.addElement(new Integer(n));
    }

    public final synchronized void addElement(double d) {
        this.addElement(new Double(d));
    }

    public void addElements(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            this.internalVector.addElement(objectArray[n]);
            ++n;
        }
    }

    public void addElements(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            this.internalVector.addElement(vector.elementAt(n));
            ++n;
        }
    }

    public synchronized OrderedCollection reversed() {
        List list = new List(this.size());
        Enumeration enumeration = this.elementsReversed();
        while (enumeration.hasMoreElements()) {
            list.addElement(enumeration.nextElement());
        }
        return list;
    }

    public synchronized OrderedCollection shuffled() {
        List list = new List(this.size());
        Object[] objectArray = new Object[this.size()];
        this.internalVector.copyInto(objectArray);
        Random random = new Random();
        int n = this.size();
        while (n > 0) {
            int n2 = Math.abs(random.nextInt()) % n;
            list.addElement(objectArray[n2]);
            objectArray[n2] = objectArray[n - 1];
            --n;
        }
        return list;
    }

    public Enumeration elements() {
        return this.internalVector.elements();
    }

    public void trimToSize() {
        this.internalVector.trimToSize();
    }

    public void ensureCapacity(int n) {
        this.internalVector.ensureCapacity(n);
    }

    public void setSize(int n) {
        this.internalVector.setSize(n);
    }

    public int capacity() {
        return this.internalVector.capacity();
    }

    public int size() {
        return this.internalVector.size();
    }

    public boolean isEmpty() {
        return this.internalVector.isEmpty();
    }

    public boolean contains(Object object) {
        return this.internalVector.contains(object);
    }

    public int indexOf(Object object) {
        return this.internalVector.indexOf(object);
    }

    public int indexOf(Object object, int n) {
        return this.internalVector.indexOf(object, n);
    }

    public int lastIndexOf(Object object) {
        return this.internalVector.lastIndexOf(object);
    }

    public int lastIndexOf(Object object, int n) {
        return this.internalVector.lastIndexOf(object, n);
    }

    public Object elementAt(int n) {
        return this.internalVector.elementAt(n);
    }

    public Object firstElement() {
        return this.internalVector.firstElement();
    }

    public Object lastElement() {
        return this.internalVector.lastElement();
    }

    public void setElementAt(Object object, int n) {
        this.internalVector.setElementAt(object, n);
    }

    public void removeElementAt(int n) {
        this.internalVector.removeElementAt(n);
    }

    public void insertElementAt(Object object, int n) {
        this.internalVector.insertElementAt(object, n);
    }

    public void addElement(Object object) {
        this.internalVector.addElement(object);
    }

    public boolean removeElement(Object object) {
        return this.internalVector.removeElement(object);
    }

    public void removeAllElements() {
        this.internalVector.removeAllElements();
    }

    public void replaceElements(Object[] objectArray) {
        this.internalVector.removeAllElements();
        this.addElements(objectArray);
    }

    public synchronized Object clone() {
        try {
            List list = (List)super.clone();
            list.internalVector = (Vector)this.internalVector.clone();
            return list;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public static void main(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        vector.addElement("one");
        vector.addElement("two");
        vector.addElement("three");
        List list = new List(vector);
        System.out.println(list.toString());
        List list2 = (List)list.reversed();
        System.out.println(list2.toString());
        list = new List();
        try {
            list.fromString("foo,bar,joe");
            System.out.println(list.toString());
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public List() {
        this(10);
    }

    public List(int n) {
        this.internalVector = new Vector(n, 0);
    }

    public List(Vector vector) {
        this.internalVector = new Vector();
        this.addElements(vector);
    }

    public List(Object[] objectArray) {
        this.internalVector = new Vector();
        this.addElements(objectArray);
    }
}

