/*
   Copyright (c) DFN-CERT, Univ. of Hamburg 1994

   Univ. Hamburg, Dept. of Computer Science
   DFN-CERT
   Vogt-Koelln-Strasse 30
   22527 Hamburg
   Germany
*/


#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <utmp.h>
#include <time.h>
#include <sys/time.h>
#include <sys/file.h>

#define WTMP_FILENAME "/var/adm/wtmp"


void printit(counter, start, end)
int counter;
long start,end;
{
	char		buffer[30];

	printf("%d deletion(s) between ", counter);
	strcpy(buffer, ctime( (time_t *) &start));
	buffer[24]='\0';
	printf("%s and %s", buffer, ctime( (time_t *) &end));
}


int main() {
	int		filehandle;
	struct utmp	utmp_ent;
	struct timeval	mytime;
	struct timezone	dummy;
	long		start_time, act_time;
	int		del_counter;

	del_counter=0;
	start_time=0;

	gettimeofday(&mytime, &dummy);
	act_time=mytime.tv_sec;

	if ((filehandle=open(WTMP_FILENAME,O_RDONLY)) < 0) {
		fprintf(stderr, "unable to open wtmp-file %s\n", WTMP_FILENAME);
		return(2);
	}

	while (read (filehandle, (char *) &utmp_ent, sizeof (struct utmp)) > 0) {
		if (utmp_ent.ut_time == 0)
			del_counter++;
		else {
			if (del_counter) {
				printit(del_counter, start_time,
					utmp_ent.ut_time);
				del_counter=0;
			}
			start_time=utmp_ent.ut_time;
		}
	}
	close(filehandle);
	if (del_counter)
		printit(del_counter, start_time, act_time);
	return(0);
}

