
/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/ip_var.h>
#include <netinet/udp.h>
#include <netinet/udp_var.h>

#include <cons_out.h>
#include <cons_util.h>

void cons_init ();
int updatetime ();
void check_timeouts ();
void argus_loop ();
void cleanup ();
void usr1sig ();
void usr2sig ();
void usage ();
int add_to_queue ();
void remove_from_queue ();
void update_queue_status ();
char *copy_argv ();
char *read_infile ();
void aerror ();
void bpf_dump ();

void cons_ether_init ();
void cons_ether_packet ();
void cons_fddi_packet ();
void cons_icmp ();
void cons_ip_init ();
void argus_ip_handler ();
void check_ip_timeouts ();
void cons_socket_init ();
void writeOutData ();
int establish_listen ();
void check_tcp_timeouts ();
void check_client_status ();
void close_clients ();
void cons_tcp_init ();
void cons_tcp ();
void log_tcp_connection ();
void log_udp_connection ();
void log_ip_connection ();
void cons_udp_init ();
void cons_udp ();
void check_udp_timeouts ();
int tcp_wrapper ();

int sock_names();

extern struct QUEUE tcp_display_list;
extern struct QUEUE udp_display_list;
extern struct QUEUE ip_display_list;

#include <cons_def.h>

typedef void (*proc)();

#define TSEQ_HASHSIZE		9029
#define MAX_LISTEN		5


struct QUEUE_HEADER {
   struct QUEUE_HEADER *nxt;
   struct QUEUE_HEADER *prv;
   struct QUEUE *queue;
   struct timeval last_time, logtime;
};
 

struct QUEUE {
   struct QUEUE_HEADER *start;
   proc timerRoutine, logRoutine;
   int count;
};

struct HASH_TABLE_HEADER {
   struct HASH_TABLE_HEADER *nxt;
   struct HASH_TABLE_HEADER *prv;
   struct tha tha;
   u_int hash;
   struct OBJECT *object;
};
 
struct HASH_TABLE {
   struct HASH_TABLE_HEADER **hash_array;
   u_int size;
};
