
/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */



struct TIME_ENTRY {
   struct TIME_ENTRY *nxt;
   u_int startime;
   u_int lasttime;
};

struct PORT_ENTRY {
   struct PORT_ENTRY *nxt;
   u_int port_num;
};

struct ETHER_ENTRY {
   struct ETHER_ENTRY *nxt;
   struct ether_addr eaddr;
   int test;
};

struct STAT {
   int pkts, bytes;
   double pkts_sqrd, bytes_sqrd;
   double bytes_per_pkt, bytes_per_pkt_sqrd;
};

struct STATISTICS {
   int cons;
   double secs, secs_sqrd;
   struct STAT src;
   struct STAT dst;
};

struct PORT {
   struct PORT *prv, *nxt;
   unsigned short port, proto;
   struct STATISTICS stats;
};

struct NET_OBJECT_PTR {
   struct NET_OBJECT_PTR *prv, *nxt;
   struct NET_OBJECT *net_obj;
};

struct NET_OBJECT {
   struct QUEUE_HEADER  queue;
   struct NET_OBJECT   *nxt;
   struct NET_OBJECT   *group;
   struct NETWORK      *net;
   struct IP_ENTRY     *ip_addr;
   struct STATISTICS    src_stats;
   struct STATISTICS    dst_stats;
   struct PORT         *ports;
   int type;
   int index;
};

struct ROUTE_OBJECT {
   struct QUEUE_HEADER  header;
   struct IP_ENTRY *route_list;
   struct opacket *outpacket;
   struct sockaddr whereto;
   struct timeval timeout;
   int probe, seq, ttl;
   int ident, port;
   int got_there, unreachable;
   u_long lastaddr;
};
 
 
struct NETWORK {
   struct QUEUE_HEADER queue;
   struct QUEUE list;
   struct NETWORK *nxt;
   struct NET_OBJECT net;
   struct NET_OBJECT_PTR *ent;
   u_long  ip_net;
   u_long  ip_mask;
   int hosts;
};
