
/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */

#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>


struct tha {
   struct in_addr src;
   struct in_addr dst;
   u_int port;
};

struct writeStruct {
   u_int status;
   struct timeval startime, lasttime;
   struct ether_addr ethersrc;
   struct ether_addr etherdst;
   struct tha addr;
   int src_count, dst_count;
   int src_bytes, dst_bytes;
};


struct tcpWriteStruct {
   int src_count, dst_count;
   int src_bytes, dst_bytes;
};

struct udpWriteStruct {
   int src_count, dst_count;
   int src_bytes, dst_bytes;
};

struct icmpWriteStruct {
   unsigned char type, code;
   unsigned short data;
   struct in_addr srcaddr, dstaddr, gwaddr;
};

struct physWriteStruct {
   struct ether_addr ethersrc;
   struct ether_addr etherdst;
};

struct argWriteStruct {
   struct timeval time;
};

struct arpWriteStruct {
   struct timeval time;
   struct physWriteStruct phys;
   struct ether_arp arp;
};

struct  ipWriteStruct {
   struct timeval startime, lasttime;
   struct physWriteStruct ws_phys;
   struct in_addr src;
   struct in_addr dst;
   u_int port;
   union {
      struct  tcpWriteStruct  tcp;
      struct  udpWriteStruct  udp;
      struct icmpWriteStruct icmp;
   } ipws_trans_union;
};

struct manWriteStruct {
   struct timeval now, uptime;
   unsigned short reportInterval;
   unsigned char  interfaceType, interfaceStatus;
   unsigned long  pktsRcvd, bytesRcvd, pktsDrop;
   unsigned short rollpktsRcvd, rollbytesRcvd, rollpktsDrop;
   unsigned short actTCPcons, watTCPcons, cloTCPcons;
   unsigned short actUDPcons, cloUDPcons;
   unsigned short actIPcons,  cloIPcons;
   unsigned char  connAccess, denyAccess;
};

struct WriteStruct {
   u_int status;
   union {
      struct   argWriteStruct arg;
      struct    ipWriteStruct ip;
      struct   arpWriteStruct arp;
      struct   manWriteStruct man;
   } ws_trans_union;
};

#define ws_arg ws_trans_union.arg
#define ws_ip  ws_trans_union.ip
#define ws_arp ws_trans_union.arp
#define ws_man ws_trans_union.man

#define ws_ip_src  ws_trans_union.ip.src
#define ws_ip_dst  ws_trans_union.ip.dst
#define ws_ip_port ws_trans_union.ip.port
#define ws_ip_tcp  ws_trans_union.ip.ipws_trans_union.tcp
#define ws_ip_ucp  ws_trans_union.ip.ipws_trans_union.ucp
#define ws_ip_icmp ws_trans_union.ip.ipws_trans_union.icmp

