 /*
  * Modified source from tcp_wrappers_7.1:tcpd.c by
  *     Wietse Venema (wietse@wzv.win.tue.nl),
  *     Department of Mathematics and Computing Science,
  *     Eindhoven University of Technology,
  *     The Netherlands.
  *
  * Carter Bullard
  * FORE Systems, Inc.
  * Warrendale, Pennsylvania
  */

/* System libraries. */

#include <stdlib.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>
#include <syslog.h>

extern char *strrchr();
extern char *strcpy();

#ifndef MAXPATHNAMELEN
#define MAXPATHNAMELEN   BUFSIZ
#endif

/* Local stuff.  */

#ifdef WRAPVERS7
#include "tcpd.h"
#else
#include <log_tcp.h>
#endif

#define FACILITY LOG_MAIL
#define SEVERITY LOG_INFO

int allow_severity = SEVERITY;     /* run-time adjustable */
int deny_severity = LOG_WARNING;   /* ditto */

extern char *program_name;


tcp_wrapper (fd, from)
int fd;
struct sockaddr *from;
{
   int retn = 0;
#ifdef WRAPVERS7
   struct request_info request;
#else
   struct sockaddr our_sa;
   struct client_info client;
   int from_stat;
#endif

#ifdef LOG_MAIL
   (void) openlog(program_name, LOG_PID, FACILITY);
#else
   (void) openlog(program_name, LOG_PID);
#endif
 
   /*
    * Find out the endpoint addresses of this conversation. Host name
    * lookups and double checks will be done on demand.
    */
 
#ifdef WRAPVERS7
   request_init(&request, RQ_DAEMON, program_name, RQ_FILE, STDIN_FILENO, 0);
   request.fd = fd;
   fromhost(&request);
#else
   from_stat = sock_host(&client, fd);
#endif

   /*
    * Optionally look up and double check the remote host name. Sites
    * concerned with security may choose to refuse connections from hosts
    * that pretend to have someone elses host name.
    */
 
#ifdef PARANOID
#ifdef WRAPVERS7
   if (STR_EQ(eval_hostname(request.client), paranoid)) {
      syslog(deny_severity, "refused connect from %s", eval_client(&request)); 
      if (request.sink)
         request.sink(request.fd);
      return -1;
   }
#else
   if (from_stat == -1) {
      syslog (deny_severity, "refused connect from %s", hosts_info(client));
      retn = -1;
   }
#endif
#endif

    /*
     * The BSD rlogin and rsh daemons that came out after 4.3 BSD disallow
     * socket options at the IP level. They do so for a good reason.
     * Unfortunately, we cannot use this with SunOS 4.1.x because the
     * getsockopt() system call can panic the system.
     */  

#ifdef KILL_IP_OPTIONS
   fix_options(&request);
#endif

    /*
     * Find out and verify the remote host name. Sites concerned with
     * security may choose to refuse connections from hosts that pretend to
     * have someone elses host name.
     */  

#ifdef HOSTS_ACCESS
#ifdef WRAPVERS7
   if (!hosts_access(&request)) {
      syslog (deny_severity, "refused connect from %s", eval_client(&request));
      if (request.sink)
         request.sink(request.fd);
      return -1;
   } else
#else
   if (!hosts_access(program_name, &client)) {
      syslog (deny_severity, "refused connect from %s", hosts_info(client));
      retn = -1;
   } else
#endif
#endif

    /* Report remote client */
#ifdef WRAPVERS7
   syslog (allow_severity, "connect from %s", eval_client(&request));
#else
   syslog (allow_severity, "connect from %s", hosts_info (&client));
#endif

   return (retn);
}
